import { IsString, IsOptional, IsArray } from 'class-validator';

class UserUpdateDto {
  @IsString()
  name: string;

  @IsString()
  email: string;
}

export class UpdateUserDto {
  @IsOptional()
  @IsString()
  role_id?: string;

  @IsOptional()
  @IsString()
  reports_to_id?: string;

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  permissions?: string[];

  @IsOptional()
  user?: UserUpdateDto;
} 