import { Controller, Get, Query, UseGuards, ParseIntPipe } from '@nestjs/common';
import { UserActivityService } from './user-activity.service';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';
import { RolesGuard } from '../auth/guards/roles.guard';
import { Roles } from '../auth/decorators/roles.decorator';
import { UserRole } from '../roles/roles.model';
import { UserActivityListResponseDto } from './dto/user-activity-response.dto';

@Controller('api/core/users_activity')
@UseGuards(JwtAuthGuard, RolesGuard)
@Roles(UserRole.ADMIN, UserRole.OWNER)
export class UserActivityController {
  constructor(private readonly userActivityService: UserActivityService) {}

  @Get()
  async getUserActivities(
    @Query('user__id', ParseIntPipe) userId: number,
    @Query('limit') limit?: number,
    @Query('offset') offset?: number,
  ): Promise<UserActivityListResponseDto> {
    return this.userActivityService.getUserActivities(
      userId,
      limit ? Number(limit) : undefined,
      offset ? Number(offset) : undefined,
    );
  }
} 