export enum UserRole {
  TEAM_LEAD = 'Team Lead',
  RETENTION = 'Retention',
  REACTIVATION = 'Reactivation',
  OWNER = 'Owner',
  ESCALATOR = 'Escalator',
  AGENT = 'Agent',
  ADMIN = 'Admin'
}

export interface Role {
  id: number;
  name: UserRole | string;
  description?: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface RolePermission {
  id: number;
  name: string;
  codename: string;
  content_type: number;
}

export interface RoleWithPermissions {
  id: number;
  name: string;
  permissions: RolePermission[];
}

export interface RolesResponse {
  data: RoleWithPermissions[];
  success: boolean;
  message: string;
  status: number;
} 