import { Controller, Get, Post, Body, Put, Param, Delete, UseGuards, Logger } from '@nestjs/common';
import { RolesService } from './roles.service';
import { Role, UserRole, RolesResponse } from './roles.model';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';
import { RolesGuard } from '../auth/guards/roles.guard';
import { Roles } from '../auth/decorators/roles.decorator';

@Controller('api/users/roles')
@UseGuards(JwtAuthGuard, RolesGuard)
export class RolesController {
  private readonly logger = new Logger(RolesController.name);

  constructor(private readonly rolesService: RolesService) {}

  @Get()
  async findAll(): Promise<RolesResponse> {
    try {
      this.logger.debug('GET /api/users/roles - Finding all roles');
      const result = await this.rolesService.findAll();
      this.logger.log(`GET /api/users/roles - Successfully retrieved ${result.data?.length || 0} roles`);
      return result;
    } catch (error) {
      this.logger.error(`GET /api/users/roles - Error finding all roles: ${error.message}`, error.stack);
      throw error;
    }
  }

  @Get(':id')
  async findOne(@Param('id') id: string): Promise<Role> {
    try {
      const roleId = Number(id);
      this.logger.debug(`GET /api/users/roles/${id} - Finding role with ID: ${roleId}`);
      const result = await this.rolesService.findOne(roleId);
      this.logger.log(`GET /api/users/roles/${id} - Successfully retrieved role: ${result.name}`);
      return result;
    } catch (error) {
      this.logger.error(`GET /api/users/roles/${id} - Error finding role: ${error.message}`, error.stack);
      throw error;
    }
  }
} 