import { IsString, IsOptional, IsBoolean, IsNumber, Min } from 'class-validator';
import { Transform, Type } from 'class-transformer';

export class UpdateProductDto {
  @IsString()
  @IsOptional()
  @Transform(({ value }) => value?.trim())
  name?: string;

  @IsString()
  @IsOptional()
  @Transform(({ value }) => value?.trim())
  description?: string;

  @IsNumber()
  @IsOptional()
  @Min(0, { message: 'Amount must be greater than or equal to 0' })
  @Type(() => Number)
  amount?: number;

  @IsNumber()
  @IsOptional()
  @Min(0, { message: 'Postage/Service charges must be greater than or equal to 0' })
  @Type(() => Number)
  postageServiceCharges?: number;

  @IsBoolean()
  @IsOptional()
  isActive?: boolean;
}


