import { Module, OnModuleInit } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { OrdersService } from './orders.service';
import { OrdersController } from './orders.controller';
import { PostageServiceChargesService } from './postage-service-charges.service';
import { PostageServiceChargesController } from './postage-service-charges.controller';
import { Order } from './entities/order.entity';
import { OrderItem } from './entities/order-item.entity';
import { PostageServiceCharge } from './entities/postage-service-charge.entity';
import { Customer } from '../customers/entities/customer.entity';
import { Product } from '../products/entities/product.entity';
import { User } from '../users/entities/user.entity';
import { CustomersModule } from '../customers/customers.module';
import { ProductsModule } from '../products/products.module';

@Module({
  imports: [
    TypeOrmModule.forFeature([Order, OrderItem, PostageServiceCharge, Customer, Product, User]),
    CustomersModule,
    ProductsModule,
  ],
  controllers: [OrdersController, PostageServiceChargesController],
  providers: [OrdersService, PostageServiceChargesService],
  exports: [OrdersService, PostageServiceChargesService],
})
export class OrdersModule implements OnModuleInit {
  constructor(private readonly ordersService: OrdersService) {}

  async onModuleInit() {
    // Cleanup invalid orders (empty order numbers and invalid customerIds)
    try {
      await this.ordersService.cleanupInvalidOrders();
    } catch (error) {
      console.warn('Failed to cleanup invalid orders on module init:', error.message);
    }
  }
}

