import { IsString, IsOptional, IsNumber, Min, IsBoolean } from 'class-validator';
import { Type, Transform } from 'class-transformer';

export class UpdatePostageServiceChargeDto {
  @IsString()
  @IsOptional()
  @Transform(({ value }) => value?.trim())
  name?: string;

  @IsString()
  @IsOptional()
  @Transform(({ value }) => value?.trim())
  description?: string;

  @IsNumber()
  @IsOptional()
  @Min(0, { message: 'Amount must be greater than or equal to 0' })
  @Type(() => Number)
  amount?: number;

  @IsBoolean()
  @IsOptional()
  isActive?: boolean;
}



