import { IsInt, IsOptional, Min, IsNumber, IsString } from 'class-validator';
import { Type } from 'class-transformer';

export class UpdateOrderItemDto {
  @IsInt()
  @IsOptional()
  @Type(() => Number)
  productId?: number;

  @IsInt()
  @IsOptional()
  @Min(1, { message: 'Count must be at least 1' })
  @Type(() => Number)
  count?: number;

  @IsNumber()
  @IsOptional()
  @Min(0, { message: 'Amount per tub must be greater than or equal to 0' })
  @Type(() => Number)
  amountPerTub?: number;

  @IsNumber()
  @IsOptional()
  @Min(0, { message: 'Total amount must be greater than or equal to 0' })
  @Type(() => Number)
  totalAmount?: number;

  @IsInt()
  @IsOptional()
  @Type(() => Number)
  postageServiceChargeId?: number;

  @IsString()
  @IsOptional()
  deductionNote?: string;
}
