import { IsString, IsNotEmpty, IsNumber, Min, IsOptional } from 'class-validator';
import { Type, Transform } from 'class-transformer';

export class CreatePostageServiceChargeDto {
  @IsString()
  @IsNotEmpty({ message: 'Name is required' })
  @Transform(({ value }) => value.trim())
  name: string;

  @IsString()
  @IsOptional()
  @Transform(({ value }) => value?.trim())
  description?: string;

  @IsNumber()
  @IsNotEmpty({ message: 'Amount is required' })
  @Min(0, { message: 'Amount must be greater than or equal to 0' })
  @Type(() => Number)
  amount: number;
}



