import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { LogoutController } from './logout.controller';
import { LogoutService } from './logout.service';
import { User } from 'src/users/entities/user.entity';
import { UserActivity } from 'src/user-activity/entities/user-activity.entity';
import { UserActivityService } from 'src/user-activity/user-activity.service';

@Module({
  imports: [TypeOrmModule.forFeature([User, UserActivity])],
  controllers: [LogoutController],
  providers: [LogoutService, UserActivityService],
})
export class LogoutModule {}
