import { Controller, Post, Req, Res, UseGuards } from '@nestjs/common';
import { Request, Response } from 'express';
import { LogoutService } from './logout.service';
import { OptionalJwtAuthGuard } from '../auth/optional-jwt-auth.guard';

@Controller('/api/core/logout')
export class LogoutController {
  constructor(private readonly logoutService: LogoutService) {}

  @Post()
  @UseGuards(OptionalJwtAuthGuard)
  async logout(@Req() request: Request, @Res() response: Response) {
    return this.logoutService.logout(request, response);
  }
}