import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { JwtModule } from '@nestjs/jwt';

import { LoginService } from './login.service';
import { LoginController } from './login.controller';
import { Login } from './entities/login.entity';
import { User } from '../users/entities/user.entity';
import { EmailService } from '../common/services/email.service';
import { UserActivityModule } from '../user-activity/user-activity.module';
import { PermissionsModule } from '../permissions/permissions.module';
import { UsersModule } from '../users/users.module';

@Module({
  imports: [
    ConfigModule,
    TypeOrmModule.forFeature([Login]), // Remove User from here - it's provided by UsersModule
    UsersModule, // Import UsersModule to ensure User entity metadata is available
    JwtModule.registerAsync({
      imports: [ConfigModule],
      inject: [ConfigService],
      useFactory: async (configService: ConfigService) => ({
        secret: configService.get<string>('JWT_SECRET'),
        signOptions: {
          expiresIn: configService.get<string>('JWT_EXPIRES_IN', '1h'),
        },
      }),
    }),
    UserActivityModule,
    PermissionsModule,
  ],
  controllers: [LoginController],
  providers: [LoginService, EmailService],
})
export class LoginModule {}

