import { Module } from '@nestjs/common';
import { AdminProductsController } from './admin-products.controller';
import { AdminPostageServiceChargesController } from './admin-postage-service-charges.controller';
import { ProductsModule } from '../products/products.module';
import { OrdersModule } from '../orders/orders.module';
import { UsersModule } from '../users/users.module';
import { AuthModule } from '../auth/auth.module';
import { AdminGuard } from '../users/guards/admin.guard';

@Module({
  imports: [ProductsModule, OrdersModule, UsersModule, AuthModule],
  controllers: [
    AdminProductsController,
    AdminPostageServiceChargesController,
  ],
  providers: [AdminGuard],
})
export class AdminModule {}

