"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var AdminGuard_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminGuard = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const users_service_1 = require("../users.service");
let AdminGuard = AdminGuard_1 = class AdminGuard {
    jwtService;
    usersService;
    logger = new common_1.Logger(AdminGuard_1.name);
    constructor(jwtService, usersService) {
        this.jwtService = jwtService;
        this.usersService = usersService;
    }
    async canActivate(context) {
        const request = context.switchToHttp().getRequest();
        const token = this.extractTokenFromHeader(request);
        this.logger.debug('Authorization header:', request.headers.authorization);
        this.logger.debug('Extracted token:', token);
        if (!token) {
            throw new common_1.UnauthorizedException('No token provided');
        }
        try {
            const payload = await this.jwtService.verifyAsync(token);
            this.logger.debug('Token payload:', payload);
            const user = await this.usersService.findOne(payload.sub);
            this.logger.debug('Found user:', user);
            if (!user) {
                throw new common_1.UnauthorizedException('User not found');
            }
            const userRole = typeof user.role === 'string' ? user.role : user.role?.name;
            if (userRole !== 'Admin') {
                throw new common_1.UnauthorizedException('Only Admin users can perform this action');
            }
            console.log('User Role', user.role);
            return true;
        }
        catch (error) {
            this.logger.error('Error in AdminGuard:', error);
            if (error instanceof common_1.UnauthorizedException) {
                throw error;
            }
            throw new common_1.UnauthorizedException('Invalid token or insufficient permissions');
        }
    }
    extractTokenFromHeader(request) {
        const [type, token] = request.headers.authorization?.split(' ') ?? [];
        return type === 'Bearer' ? token : undefined;
    }
};
exports.AdminGuard = AdminGuard;
exports.AdminGuard = AdminGuard = AdminGuard_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [jwt_1.JwtService,
        users_service_1.UsersService])
], AdminGuard);
//# sourceMappingURL=admin.guard.js.map