"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ProductsService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const product_entity_1 = require("./entities/product.entity");
let ProductsService = ProductsService_1 = class ProductsService {
    productsRepository;
    logger = new common_1.Logger(ProductsService_1.name);
    constructor(productsRepository) {
        this.productsRepository = productsRepository;
    }
    async create(createProductDto) {
        try {
            this.logger.debug(`create() - Creating product with name: ${createProductDto.name}`);
            const existingProduct = await this.productsRepository.findOne({
                where: { name: createProductDto.name },
            });
            if (existingProduct) {
                this.logger.warn(`create() - Conflict: Product with name "${createProductDto.name}" already exists (ID: ${existingProduct.id})`);
                throw new common_1.ConflictException(`Product with name "${createProductDto.name}" already exists`);
            }
            const product = this.productsRepository.create(createProductDto);
            const savedProduct = await this.productsRepository.save(product);
            this.logger.log(`create() - Successfully created product with ID: ${savedProduct.id}, name: ${savedProduct.name}`);
            return savedProduct;
        }
        catch (error) {
            const errorType = error.constructor.name;
            if (error instanceof common_1.ConflictException) {
                this.logger.error(`create() - ConflictException: ${error.message}`);
                throw error;
            }
            this.logger.error(`create() - Error creating product. Error Type: ${errorType}, Message: ${error.message}`, error.stack);
            throw new common_1.BadRequestException(`Failed to create product: ${error.message || 'Unknown error occurred'}`);
        }
    }
    async findAll(listProductsDto) {
        try {
            const { page = 1, limit = 10, search, isActive } = listProductsDto;
            const skip = (page - 1) * limit;
            this.logger.debug(`findAll() - Finding products with filters: page=${page}, limit=${limit}, search=${search}, isActive=${isActive}`);
            const queryBuilder = this.productsRepository.createQueryBuilder('product');
            if (search) {
                queryBuilder.where('(product.name LIKE :search OR product.description LIKE :search)', { search: `%${search}%` });
                this.logger.debug(`findAll() - Applied search filter: ${search}`);
            }
            if (isActive !== undefined) {
                if (search) {
                    queryBuilder.andWhere('product.isActive = :isActive', { isActive });
                }
                else {
                    queryBuilder.where('product.isActive = :isActive', { isActive });
                }
                this.logger.debug(`findAll() - Applied isActive filter: ${isActive}`);
            }
            queryBuilder.skip(skip).take(limit).orderBy('product.createdAt', 'DESC');
            const [data, total] = await queryBuilder.getManyAndCount();
            this.logger.log(`findAll() - Successfully retrieved ${data.length} products (total: ${total})`);
            return { data, total };
        }
        catch (error) {
            const errorType = error.constructor.name;
            this.logger.error(`findAll() - Error finding products. Error Type: ${errorType}, Message: ${error.message}`, error.stack);
            throw error;
        }
    }
    async findOne(id) {
        try {
            this.logger.debug(`findOne() - Searching for product with ID: ${id}`);
            const product = await this.productsRepository.findOne({
                where: { id },
            });
            if (!product) {
                this.logger.warn(`findOne() - Product with ID ${id} not found`);
                throw new common_1.NotFoundException(`Product with ID ${id} not found`);
            }
            this.logger.log(`findOne() - Successfully found product with ID: ${id}, name: ${product.name}`);
            return product;
        }
        catch (error) {
            const errorType = error.constructor.name;
            if (error instanceof common_1.NotFoundException) {
                throw error;
            }
            this.logger.error(`findOne() - Error finding product with ID ${id}. Error Type: ${errorType}, Message: ${error.message}`, error.stack);
            throw error;
        }
    }
    async update(id, updateProductDto) {
        try {
            this.logger.debug(`update() - Updating product with ID: ${id}, data: ${JSON.stringify(updateProductDto)}`);
            const product = await this.findOne(id);
            if (updateProductDto.name && updateProductDto.name !== product.name) {
                this.logger.debug(`update() - Checking for name conflict: ${updateProductDto.name}`);
                const existingProduct = await this.productsRepository.findOne({
                    where: { name: updateProductDto.name },
                });
                if (existingProduct) {
                    this.logger.warn(`update() - Conflict: Product with name "${updateProductDto.name}" already exists (ID: ${existingProduct.id})`);
                    throw new common_1.ConflictException(`Product with name "${updateProductDto.name}" already exists`);
                }
            }
            Object.assign(product, updateProductDto);
            const updatedProduct = await this.productsRepository.save(product);
            this.logger.log(`update() - Successfully updated product with ID: ${id}, name: ${updatedProduct.name}`);
            return updatedProduct;
        }
        catch (error) {
            const errorType = error.constructor.name;
            if (error instanceof common_1.NotFoundException || error instanceof common_1.ConflictException) {
                throw error;
            }
            this.logger.error(`update() - Error updating product with ID ${id}. Error Type: ${errorType}, Message: ${error.message}`, error.stack);
            throw new common_1.BadRequestException(`Failed to update product: ${error.message || 'Unknown error occurred'}`);
        }
    }
    async remove(id) {
        try {
            this.logger.debug(`remove() - Deleting product with ID: ${id}`);
            const product = await this.findOne(id);
            await this.productsRepository.remove(product);
            this.logger.log(`remove() - Successfully deleted product with ID: ${id}, name: ${product.name}`);
        }
        catch (error) {
            const errorType = error.constructor.name;
            if (error instanceof common_1.NotFoundException) {
                throw error;
            }
            this.logger.error(`remove() - Error deleting product with ID ${id}. Error Type: ${errorType}, Message: ${error.message}`, error.stack);
            throw error;
        }
    }
    async seedProducts() {
        try {
            this.logger.debug('seedProducts() - Starting product seeding');
            const existingProducts = await this.productsRepository.count();
            if (existingProducts === 0) {
                this.logger.log('seedProducts() - No existing products found, seeding default products');
                const defaultProducts = [
                    {
                        name: 'Premium CRM License',
                        description: 'Full-featured CRM license with unlimited users and advanced analytics',
                    },
                    {
                        name: 'Basic CRM Package',
                        description: 'Entry-level CRM package with essential features for small teams',
                    },
                    {
                        name: 'Enterprise Support Plan',
                        description: '24/7 priority support with dedicated account manager',
                    },
                    {
                        name: 'Data Migration Service',
                        description: 'Professional data migration service from legacy systems',
                    },
                    {
                        name: 'Custom Integration Package',
                        description: 'Tailored integration solutions for third-party applications',
                    },
                ];
                let seededCount = 0;
                for (const productData of defaultProducts) {
                    const existing = await this.productsRepository.findOne({
                        where: { name: productData.name },
                    });
                    if (!existing) {
                        await this.productsRepository.save(productData);
                        seededCount++;
                    }
                }
                this.logger.log(`seedProducts() - Successfully seeded ${seededCount} default products`);
            }
            else {
                this.logger.debug(`seedProducts() - ${existingProducts} products already exist, skipping seed`);
            }
        }
        catch (error) {
            this.logger.warn(`seedProducts() - Products seeding skipped - table may not exist yet. Error Type: ${error.constructor.name}, Message: ${error.message}`);
        }
    }
};
exports.ProductsService = ProductsService;
exports.ProductsService = ProductsService = ProductsService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], ProductsService);
//# sourceMappingURL=products.service.js.map