import { HttpStatus } from '@nestjs/common';
import { ProductsService } from './products.service';
import { CreateProductDto } from './dto/create-product.dto';
import { UpdateProductDto } from './dto/update-product.dto';
import { ListProductsDto } from './dto/list-products.dto';
export declare class ProductsController {
    private readonly productsService;
    private readonly logger;
    constructor(productsService: ProductsService);
    create(createProductDto: CreateProductDto): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: import("./entities/product.entity").Product;
    }>;
    findAll(listProductsDto: ListProductsDto): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: import("./entities/product.entity").Product[];
        total: number;
    }>;
    findOne(id: string): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: import("./entities/product.entity").Product;
    }>;
    update(id: string, updateProductDto: UpdateProductDto): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: import("./entities/product.entity").Product;
    }>;
    remove(id: string): Promise<{
        statusCode: HttpStatus;
        message: string;
    }>;
}
