import { Repository } from 'typeorm';
import { Permission } from './entities/permission.entity';
import { PermissionsResponse, PermissionResponse } from './permissions.model';
export declare class PermissionsService {
    private permissionsRepository;
    constructor(permissionsRepository: Repository<Permission>);
    private getContentType;
    private formatCodename;
    findAll(role?: string): Promise<PermissionsResponse & {
        customer_permissions: PermissionResponse[];
        user_permissions: PermissionResponse[];
    }>;
    findAllGrouped(role?: string): Promise<{
        grouped: any;
        data: PermissionResponse[];
        success: boolean;
        message: string;
        status: number;
        customer_permissions: PermissionResponse[];
        user_permissions: PermissionResponse[];
    }>;
    findByCategory(category: string): Promise<PermissionsResponse>;
    findByEntity(category: string, entity: string): Promise<PermissionsResponse>;
    findOne(id: number): Promise<Permission | null>;
    getAllPermissions(): Promise<PermissionResponse[]>;
    groupPermissions(permissions: PermissionResponse[]): any;
}
