"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostageServiceChargesService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const postage_service_charge_entity_1 = require("./entities/postage-service-charge.entity");
let PostageServiceChargesService = class PostageServiceChargesService {
    postageServiceChargesRepository;
    constructor(postageServiceChargesRepository) {
        this.postageServiceChargesRepository = postageServiceChargesRepository;
    }
    async create(createDto) {
        try {
            const existing = await this.postageServiceChargesRepository.findOne({
                where: { name: createDto.name },
            });
            if (existing) {
                throw new common_1.ConflictException(`Postage/Service charge with name "${createDto.name}" already exists`);
            }
            const charge = this.postageServiceChargesRepository.create(createDto);
            return await this.postageServiceChargesRepository.save(charge);
        }
        catch (error) {
            if (error instanceof common_1.ConflictException) {
                throw error;
            }
            throw new common_1.BadRequestException(`Failed to create postage/service charge: ${error.message}`);
        }
    }
    async findAll() {
        return await this.postageServiceChargesRepository.find({
            where: { isActive: true },
            order: { createdAt: 'DESC' },
        });
    }
    async findAllIncludingInactive() {
        return await this.postageServiceChargesRepository.find({
            order: { createdAt: 'DESC' },
        });
    }
    async findOne(id) {
        const charge = await this.postageServiceChargesRepository.findOne({
            where: { id },
        });
        if (!charge) {
            throw new common_1.NotFoundException(`Postage/Service charge with ID ${id} not found`);
        }
        return charge;
    }
    async update(id, updateDto) {
        const charge = await this.findOne(id);
        if (updateDto.name && updateDto.name !== charge.name) {
            const existing = await this.postageServiceChargesRepository.findOne({
                where: { name: updateDto.name },
            });
            if (existing) {
                throw new common_1.ConflictException(`Postage/Service charge with name "${updateDto.name}" already exists`);
            }
        }
        Object.assign(charge, updateDto);
        return await this.postageServiceChargesRepository.save(charge);
    }
    async remove(id) {
        const charge = await this.findOne(id);
        charge.isActive = false;
        await this.postageServiceChargesRepository.save(charge);
    }
};
exports.PostageServiceChargesService = PostageServiceChargesService;
exports.PostageServiceChargesService = PostageServiceChargesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(postage_service_charge_entity_1.PostageServiceCharge)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], PostageServiceChargesService);
//# sourceMappingURL=postage-service-charges.service.js.map