"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostageServiceChargesController = void 0;
const common_1 = require("@nestjs/common");
const postage_service_charges_service_1 = require("./postage-service-charges.service");
const create_postage_service_charge_dto_1 = require("./dto/create-postage-service-charge.dto");
const update_postage_service_charge_dto_1 = require("./dto/update-postage-service-charge.dto");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const roles_guard_1 = require("../auth/guards/roles.guard");
let PostageServiceChargesController = class PostageServiceChargesController {
    postageServiceChargesService;
    constructor(postageServiceChargesService) {
        this.postageServiceChargesService = postageServiceChargesService;
    }
    async create(createDto) {
        const charge = await this.postageServiceChargesService.create(createDto);
        return {
            statusCode: common_1.HttpStatus.CREATED,
            message: 'Postage/Service charge created successfully',
            data: charge,
        };
    }
    async findAll() {
        const charges = await this.postageServiceChargesService.findAll();
        return {
            statusCode: common_1.HttpStatus.OK,
            message: 'Postage/Service charges retrieved successfully',
            data: charges,
        };
    }
    async findAllIncludingInactive() {
        const charges = await this.postageServiceChargesService.findAllIncludingInactive();
        return {
            statusCode: common_1.HttpStatus.OK,
            message: 'All postage/service charges retrieved successfully',
            data: charges,
        };
    }
    async findOne(id) {
        const charge = await this.postageServiceChargesService.findOne(+id);
        return {
            statusCode: common_1.HttpStatus.OK,
            message: 'Postage/Service charge retrieved successfully',
            data: charge,
        };
    }
    async update(id, updateDto) {
        const charge = await this.postageServiceChargesService.update(+id, updateDto);
        return {
            statusCode: common_1.HttpStatus.OK,
            message: 'Postage/Service charge updated successfully',
            data: charge,
        };
    }
    async remove(id) {
        await this.postageServiceChargesService.remove(+id);
        return {
            statusCode: common_1.HttpStatus.OK,
            message: 'Postage/Service charge deleted successfully',
        };
    }
};
exports.PostageServiceChargesController = PostageServiceChargesController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_postage_service_charge_dto_1.CreatePostageServiceChargeDto]),
    __metadata("design:returntype", Promise)
], PostageServiceChargesController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PostageServiceChargesController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('all'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PostageServiceChargesController.prototype, "findAllIncludingInactive", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PostageServiceChargesController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_postage_service_charge_dto_1.UpdatePostageServiceChargeDto]),
    __metadata("design:returntype", Promise)
], PostageServiceChargesController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PostageServiceChargesController.prototype, "remove", null);
exports.PostageServiceChargesController = PostageServiceChargesController = __decorate([
    (0, common_1.Controller)('api/postage-service-charges'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, permissions_guard_1.PermissionsGuard, roles_guard_1.RolesGuard),
    __metadata("design:paramtypes", [postage_service_charges_service_1.PostageServiceChargesService])
], PostageServiceChargesController);
//# sourceMappingURL=postage-service-charges.controller.js.map