import { Repository, DataSource } from 'typeorm';
import { Order } from './entities/order.entity';
import { OrderItem } from './entities/order-item.entity';
import { PostageServiceCharge } from './entities/postage-service-charge.entity';
import { Customer } from '../customers/entities/customer.entity';
import { Product } from '../products/entities/product.entity';
import { User } from '../users/entities/user.entity';
import { CreateOrderDto } from './dto/create-order.dto';
import { UpdateOrderDto } from './dto/update-order.dto';
import { ListOrdersDto } from './dto/list-orders.dto';
export declare class OrdersService {
    private readonly ordersRepository;
    private readonly orderItemsRepository;
    private readonly postageServiceChargesRepository;
    private readonly customersRepository;
    private readonly productsRepository;
    private readonly usersRepository;
    private readonly dataSource;
    private readonly logger;
    constructor(ordersRepository: Repository<Order>, orderItemsRepository: Repository<OrderItem>, postageServiceChargesRepository: Repository<PostageServiceCharge>, customersRepository: Repository<Customer>, productsRepository: Repository<Product>, usersRepository: Repository<User>, dataSource: DataSource);
    private generateOrderNumber;
    cleanupInvalidOrders(): Promise<void>;
    fixEmptyOrderNumbers(): Promise<void>;
    create(createOrderDto: CreateOrderDto, user: User): Promise<Order>;
    findAll(listOrdersDto: ListOrdersDto, user: User): Promise<{
        data: Order[];
        total: number;
    }>;
    findOne(id: number, user: User): Promise<Order>;
    update(id: number, updateOrderDto: UpdateOrderDto, user: User): Promise<Order>;
    remove(id: number, user: User): Promise<void>;
}
