import { Repository } from 'typeorm';
import { Customer } from './entities/customer.entity';
import { Address } from './entities/address.entity';
import { CustomerNote } from './entities/customer-note.entity';
import { User } from '../users/entities/user.entity';
import { CreateCustomerDto } from './dto/create-customer.dto';
import { UpdateCustomerDto } from './dto/update-customer.dto';
import { ListCustomersDto } from './dto/list-customers.dto';
import { BulkAssignCustomerDto } from './dto/bulk-assign-customer.dto';
export declare class CustomersService {
    private readonly customersRepository;
    private readonly addressesRepository;
    private readonly customerNotesRepository;
    private readonly usersRepository;
    constructor(customersRepository: Repository<Customer>, addressesRepository: Repository<Address>, customerNotesRepository: Repository<CustomerNote>, usersRepository: Repository<User>);
    private allocateUniqueCustomerId;
    create(createCustomerDto: CreateCustomerDto, user: any): Promise<Customer>;
    update(id: number, updateCustomerDto: UpdateCustomerDto, user: any): Promise<Customer>;
    updateById(id: number, updateCustomerDto: UpdateCustomerDto, user: any): Promise<Customer>;
    findOne(id: number, user: any): Promise<any>;
    findOneByCustomerId(customerId: string, user: any): Promise<any>;
    findAll(listCustomersDto: ListCustomersDto, user: any): Promise<{
        data: any[];
        total: number;
    }>;
    bulkAssign(dto: BulkAssignCustomerDto, user: any): Promise<string>;
    bulkCreate(file: Express.Multer.File, user: any): Promise<{
        message: string;
        details: {
            success: number;
            failed: number;
            errors: string[];
            duplicateIds: string[];
        };
    }>;
    private findDuplicateRowsInFile;
    private validateDuplicatesInFile;
    private checkExistingRecords;
}
