"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtTokenActivityController = void 0;
const common_1 = require("@nestjs/common");
const jwt_token_activity_service_1 = require("../services/jwt-token-activity.service");
const jwt_auth_guard_1 = require("../guards/jwt-auth.guard");
let JwtTokenActivityController = class JwtTokenActivityController {
    jwtTokenActivityService;
    constructor(jwtTokenActivityService) {
        this.jwtTokenActivityService = jwtTokenActivityService;
    }
    async getTokenActivities(userId, limit = 10, offset = 0) {
        return this.jwtTokenActivityService.getTokenActivities(Number(userId), Number(limit), Number(offset));
    }
};
exports.JwtTokenActivityController = JwtTokenActivityController;
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('user__id')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Query)('offset')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, Number]),
    __metadata("design:returntype", Promise)
], JwtTokenActivityController.prototype, "getTokenActivities", null);
exports.JwtTokenActivityController = JwtTokenActivityController = __decorate([
    (0, common_1.Controller)('api/core/token-activities'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __metadata("design:paramtypes", [jwt_token_activity_service_1.JwtTokenActivityService])
], JwtTokenActivityController);
//# sourceMappingURL=jwt-token-activity.controller.js.map