export interface Permission {
  id: number;
  category: string;
  entity: string;
  action: string;
  role: string; // Comma-separated role IDs
  role_name: string;
  createdAt: Date;
  updatedAt: Date;
}

export interface PermissionResponse {
  id: number;
  name: string;
  codename: string;
  content_type: number;
}

export interface PermissionsResponse {
  data: PermissionResponse[];
  success: boolean;
  message: string;
  status: number;
}

export interface PermissionCategory {
  name: string;
  entities: {
    name: string;
    actions: string[];
  }[];
}

export const PERMISSION_CATEGORIES: PermissionCategory[] = [
  {
    name: 'Administration',
    entities: [
      {
        name: 'log entry',
        actions: ['Can add log entry', 'Can change log entry', 'Can delete log entry', 'Can view log entry']
      }
    ]
  },
  {
    name: 'Authentication and Authorization',
    entities: [
      {
        name: 'group',
        actions: ['Can add group', 'Can change group', 'Can delete group', 'Can view group']
      },
      {
        name: 'permission',
        actions: ['Can add permission', 'Can change permission', 'Can delete permission', 'Can view permission']
      }
    ]
  },
  {
    name: 'Content Types',
    entities: [
      {
        name: 'content type',
        actions: ['Can add content type', 'Can change content type', 'Can delete content type', 'Can view content type']
      }
    ]
  },
  {
    name: 'Core',
    entities: [
      {
        name: 'app version',
        actions: ['Can add employees', 'Can change employees', 'Can delete employees', 'Can view employees']
      },
      {
        name: 'audit log',
        actions: ['Can add historical employees', 'Can change historical employees', 'Can delete historical employees', 'Can view historical employees']
      },
      {
        name: 'otp',
        actions: ['Can add historical user', 'Can change historical user', 'Can delete historical user', 'Can view historical user']
      },
      {
        name: 'user activity',
        actions: ['Can add address', 'Can change address', 'Can delete address', 'Can view address']
      },
      {
        name: 'user notification',
        actions: ['Can add customer assignment history', 'Can change customer assignment history', 'Can delete customer assignment history', 'Can view customer assignment history']
      }
    ]
  },
  {
    name: 'Customers',
    entities: [
      {
        name: 'address',
        actions: ['Can add address', 'Can change address', 'Can delete address', 'Can view address']
      },
      {
        name: 'customer',
        actions: ['Can add customer', 'Can change Assigned To', 'Can change customer', 'Can change DNC', 'Can delete customer', 'Can view customer']
      },
      {
        name: 'customer assignment history',
        actions: ['Can add customer assignment history', 'Can change customer assignment history', 'Can delete customer assignment history', 'Can view customer assignment history']
      },
      {
        name: 'customer notes',
        actions: ['Can add customer notes', 'Can change customer notes', 'Can delete customer notes', 'Can view customer notes']
      },
      {
        name: 'historical customer',
        actions: ['Can add historical customer', 'Can change historical customer', 'Can delete historical customer', 'Can view historical customer']
      }
    ]
  },
  {
    name: 'Periodic Tasks',
    entities: [
      {
        name: 'clocked',
        actions: ['Can add otp', 'Can change otp', 'Can delete otp', 'Can view otp']
      },
      {
        name: 'crontab',
        actions: ['Can add user activity', 'Can change user activity', 'Can delete user activity', 'Can view user activity']
      },
      {
        name: 'interval',
        actions: ['Can add audit log', 'Can change audit log', 'Can delete audit log', 'Can view audit log']
      },
      {
        name: 'periodic task',
        actions: ['Can add user', 'Can change user', 'Can delete user', 'Can view user']
      },
      {
        name: 'periodic task track',
        actions: ['Can add user notification', 'Can change user notification', 'Can delete user notification', 'Can view user notification']
      },
      {
        name: 'solar event',
        actions: ['Can add app version', 'Can change app version', 'Can delete app version', 'Can view app version']
      }
    ]
  },
  {
    name: 'Orders',
    entities: [
      {
        name: 'historical proforma',
        actions: ['Can add historical proforma', 'Can change historical proforma', 'Can delete historical proforma', 'Can view historical proforma']
      },
      {
        name: 'order details',
        actions: ['Can add order details', 'Can confirm order status', 'Can change order details', 'Can delete order details', 'Can view order details']
      },
      {
        name: 'order item',
        actions: ['Can add order item', 'Can change order item', 'Can delete order item', 'Can view order item']
      },
      {
        name: 'proforma',
        actions: ['Can add proforma', 'Can change proforma', 'Can delete proforma', 'Can view proforma']
      }
    ]
  },
  {
    name: 'Products',
    entities: [
      {
        name: 'product',
        actions: ['Can add product', 'Can change Stock Level', 'Can change product', 'Can delete product', 'Can view product']
      },
      {
        name: 'product variation',
        actions: ['Can add product variation', 'Can change product variation', 'Can delete product variation', 'Can view product variation']
      },
      {
        name: 'stock update log',
        actions: ['Can add stock update log', 'Can change stock update log', 'Can delete stock update log', 'Can view stock update log']
      },
      {
        name: 'variation details',
        actions: ['Can add variation details', 'Can change variation details', 'Can delete variation details', 'Can view variation details']
      },
      {
        name: 'variation option',
        actions: ['Can add variation option', 'Can change variation option', 'Can delete variation option', 'Can view variation option']
      },
      {
        name: 'variation types',
        actions: ['Can add variation types', 'Can change variation types', 'Can delete variation types', 'Can view variation types']
      }
    ]
  },
  {
    name: 'Sessions',
    entities: [
      {
        name: 'session',
        actions: ['Can add session', 'Can change session', 'Can delete session', 'Can view session']
      }
    ]
  },
  {
    name: 'Token Blacklist',
    entities: [
      {
        name: 'blacklisted token',
        actions: ['Can add outstanding token', 'Can change outstanding token', 'Can delete outstanding token', 'Can view outstanding token']
      },
      {
        name: 'outstanding token',
        actions: ['Can add blacklisted token', 'Can change blacklisted token', 'Can delete blacklisted token', 'Can view blacklisted token']
      }
    ]
  },
  {
    name: 'Users',
    entities: [
      {
        name: 'employees',
        actions: ['Can add employees', 'Can change employees', 'Can delete employees', 'Can view employees']
      },
      {
        name: 'historical employees',
        actions: ['Can add customer', 'Can change Assigned To', 'Can change DNC', 'Can change customer', 'Can delete customer', 'Can view customer']
      },
      {
        name: 'historical user',
        actions: ['Can add customer notes', 'Can change customer notes', 'Can delete customer notes', 'Can view customer notes']
      },
      {
        name: 'user',
        actions: ['Can add historical customer', 'Can change historical customer', 'Can delete historical customer', 'Can view historical customer']
      }
    ]
  }
];