import { Controller, Get, Param, UseGuards, NotFoundException, Query, BadRequestException } from '@nestjs/common';
import { PermissionsService } from './permissions.service';
import { Permission } from './entities/permission.entity';
import { JwtAuthGuard } from '../auth/guards/jwt-auth.guard';
import { RolesGuard } from '../auth/guards/roles.guard';
import { Roles } from '../auth/decorators/roles.decorator';
import { UserRole } from '../roles/roles.model';
import { PermissionsResponse } from './permissions.model';

@Controller('api/users/permissions')
@UseGuards(JwtAuthGuard, RolesGuard)
export class PermissionsController {
  constructor(private readonly permissionsService: PermissionsService) {}

  @Get()
  async findAll(@Query('role') role?: string): Promise<PermissionsResponse> {
    return this.permissionsService.findAll(role);
  }

  @Get('category/:category')
  async findByCategory(@Param('category') category: string): Promise<PermissionsResponse> {
    return this.permissionsService.findByCategory(category);
  }

  @Get('category/:category/entity/:entity')
  async findByEntity(
    @Param('category') category: string,
    @Param('entity') entity: string,
  ): Promise<PermissionsResponse> {
    return this.permissionsService.findByEntity(category, entity);
  }

  @Get(':id')
  async findOne(@Param('id') id: string): Promise<Permission> {
    const permission = await this.permissionsService.findOne(Number(id));
    if (!permission) {
      throw new NotFoundException(`Permission with ID ${id} not found`);
    }
    return permission;
  }
}