import { IsInt, IsNotEmpty, Min } from 'class-validator';
import { Type } from 'class-transformer';

export class CreateOrderItemDto {
  @IsInt()
  @IsNotEmpty({ message: 'Product ID is required' })
  @Type(() => Number)
  productId: number;

  @IsInt()
  @IsNotEmpty({ message: 'Count is required' })
  @Min(1, { message: 'Count must be at least 1' })
  @Type(() => Number)
  count: number;
}

