import { IsString, IsNotEmpty, IsInt, IsOptional, IsBoolean } from 'class-validator';

export class CreateCustomerNoteDto {
  @IsString()
  @IsNotEmpty({ message: 'Note is required' })
  note: string;

  @IsInt()
  @IsNotEmpty({ message: 'Customer ID is required' })
  customer: number;

  @IsInt()
  @IsOptional()
  parent_note: number | null;

  @IsInt()
  @IsOptional()
  child_note_id?: number | null;

  @IsBoolean()
  @IsOptional()
  isActive?: boolean;
}
