"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomersService = void 0;
const XLSX = require("xlsx");
const common_1 = require("@nestjs/common");
const common_2 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const customer_entity_1 = require("./entities/customer.entity");
const address_entity_1 = require("./entities/address.entity");
const customer_note_entity_1 = require("./entities/customer-note.entity");
const user_entity_1 = require("../users/entities/user.entity");
let CustomersService = class CustomersService {
    customersRepository;
    addressesRepository;
    customerNotesRepository;
    usersRepository;
    constructor(customersRepository, addressesRepository, customerNotesRepository, usersRepository) {
        this.customersRepository = customersRepository;
        this.addressesRepository = addressesRepository;
        this.customerNotesRepository = customerNotesRepository;
        this.usersRepository = usersRepository;
    }
    async allocateUniqueCustomerId() {
        const pad = (n) => n.toString().padStart(2, '0');
        for (let i = 0; i < 10; i++) {
            const now = new Date();
            const y = now.getFullYear();
            const m = pad(now.getMonth() + 1);
            const d = pad(now.getDate());
            const rand = Math.random().toString(36).slice(2, 8).toUpperCase();
            const candidate = `CUST-${y}${m}${d}-${rand}`;
            const exists = await this.customersRepository.findOne({ where: { customerId: candidate } });
            if (!exists)
                return candidate;
        }
        return `CUST-${Date.now()}-${Math.random().toString(36).slice(2).toUpperCase()}`;
    }
    async create(createCustomerDto, user) {
        if (!user || !user.id) {
            throw new common_2.UnauthorizedException('User must be authenticated');
        }
        const { email, first_name, last_name, home_phone, mobile_phone, address, title, iso, DNC, is_land_line_default, assigned_to_id } = createCustomerDto;
        if (email) {
            const existingCustomer = await this.customersRepository.findOne({ where: { email } });
            if (existingCustomer) {
                throw new common_2.ConflictException('Email already exists');
            }
        }
        if (assigned_to_id) {
            const assignee = await this.usersRepository.findOne({ where: { id: parseInt(assigned_to_id.toString(), 10) } });
            if (!assignee) {
                throw new common_2.NotFoundException(`User with ID ${assigned_to_id} not found`);
            }
        }
        try {
            const [maxRow] = await this.customersRepository.query(`SELECT COALESCE(MAX(id), 0) AS maxId FROM customers`);
            const [aiRow] = await this.customersRepository.query(`
        SELECT AUTO_INCREMENT AS nextId
        FROM INFORMATION_SCHEMA.TABLES
        WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'customers'
      `);
            const maxId = Number(maxRow?.maxId ?? 0);
            const nextId = Number(aiRow?.nextId ?? 1);
            if (nextId <= maxId) {
                await this.customersRepository.query(`ALTER TABLE customers AUTO_INCREMENT = ${maxId + 1}`);
            }
        }
        catch (_) {
        }
        const customer = this.customersRepository.create({
            firstName: first_name,
            lastName: last_name,
            email,
            mobileNumber: mobile_phone,
            landline: home_phone,
            title,
            iso,
            dnc: DNC || false,
            isLandLineDefault: is_land_line_default !== undefined ? is_land_line_default : true,
            assigned_to_id: assigned_to_id ? parseInt(assigned_to_id.toString(), 10) : user.id,
            createdById: user.id,
            isActive: true,
        });
        customer.customerId = await this.allocateUniqueCustomerId();
        const savedCustomer = await this.customersRepository.save(customer);
        if (address && address.length > 0) {
            const addresses = address.map((addr) => this.addressesRepository.create({
                ...addr,
                customer: savedCustomer,
                isActive: true,
            }));
            await this.addressesRepository.save(addresses);
            savedCustomer.addresses = addresses;
        }
        return savedCustomer;
    }
    async update(id, updateCustomerDto, user) {
        if (!user || !user.id) {
            throw new common_2.UnauthorizedException('User must be authenticated');
        }
        console.log(`Updating customer with ID: ${id}`);
        const customer = await this.customersRepository.findOne({ where: { id }, relations: ['addresses'] });
        if (!customer) {
            throw new common_2.NotFoundException(`Customer with ID ${id} not found`);
        }
        const roleName = typeof user.role === 'string' ? user.role : user.role?.name || '';
        if (customer.assigned_to_id !== user.id && customer.createdById !== user.id && roleName.toLowerCase() !== 'admin' && roleName.toLowerCase() !== 'owner') {
            throw new common_2.UnauthorizedException('Not authorized to update this customer');
        }
        if (updateCustomerDto.email && updateCustomerDto.email !== customer.email) {
            const existingCustomer = await this.customersRepository.findOne({ where: { email: updateCustomerDto.email } });
            if (existingCustomer) {
                throw new common_2.ConflictException('Email already exists');
            }
        }
        if (updateCustomerDto.gen_customer_id && updateCustomerDto.gen_customer_id !== customer.genCustomerId) {
            const existingCustomer = await this.customersRepository.findOne({ where: { genCustomerId: updateCustomerDto.gen_customer_id } });
            if (existingCustomer) {
                throw new common_2.ConflictException('Generated customer ID already exists');
            }
        }
        if (updateCustomerDto.assigned_to_id) {
            const assignee = await this.usersRepository.findOne({ where: { id: parseInt(updateCustomerDto.assigned_to_id.toString(), 10) } });
            if (!assignee) {
                throw new common_2.NotFoundException(`User with ID ${updateCustomerDto.assigned_to_id} not found`);
            }
        }
        const updatedCustomer = this.customersRepository.merge(customer, {
            firstName: updateCustomerDto.first_name,
            lastName: updateCustomerDto.last_name,
            email: updateCustomerDto.email,
            mobileNumber: updateCustomerDto.mobile_phone,
            landline: updateCustomerDto.home_phone,
            title: updateCustomerDto.title,
            iso: updateCustomerDto.iso,
            dnc: updateCustomerDto.DNC,
            isLandLineDefault: updateCustomerDto.is_land_line_default,
            isActive: updateCustomerDto.is_active,
            customerId: updateCustomerDto.customer_id,
            genCustomerId: updateCustomerDto.gen_customer_id,
            assigned_to_id: updateCustomerDto.assigned_to_id ? parseInt(updateCustomerDto.assigned_to_id.toString(), 10) : customer.assigned_to_id,
        });
        const savedCustomer = await this.customersRepository.save(updatedCustomer);
        if (updateCustomerDto.address) {
            const existingAddresses = customer.addresses || [];
            const updatedAddressIds = updateCustomerDto.address
                .filter((addr) => addr.id)
                .map((addr) => addr.id);
            for (const existingAddress of existingAddresses) {
                if (!updatedAddressIds.includes(existingAddress.id)) {
                    existingAddress.isActive = false;
                    await this.addressesRepository.save(existingAddress);
                }
            }
            const addresses = await Promise.all(updateCustomerDto.address.map(async (addr) => {
                if (addr.id) {
                    const existingAddress = existingAddresses.find((ea) => ea.id === addr.id);
                    if (existingAddress) {
                        return this.addressesRepository.merge(existingAddress, {
                            ...addr,
                            isActive: addr.is_active !== undefined ? addr.is_active : existingAddress.isActive,
                        });
                    }
                }
                return this.addressesRepository.create({
                    ...addr,
                    customer: savedCustomer,
                    isActive: addr.is_active !== undefined ? addr.is_active : true,
                });
            }));
            await this.addressesRepository.save(addresses);
            savedCustomer.addresses = addresses;
        }
        return savedCustomer;
    }
    async updateById(id, updateCustomerDto, user) {
        if (!user || !user.id) {
            throw new common_2.UnauthorizedException('User must be authenticated');
        }
        console.log(`Updating customer with id: ${id}`);
        const customer = await this.customersRepository.findOne({ where: { id }, relations: ['addresses'] });
        if (!customer) {
            throw new common_2.NotFoundException(`Customer with id ${id} not found`);
        }
        const roleName = typeof user.role === 'string' ? user.role : user.role?.name || '';
        if (customer.assigned_to_id !== user.id && customer.createdById !== user.id && roleName.toLowerCase() !== 'admin' && roleName.toLowerCase() !== 'owner') {
            throw new common_2.UnauthorizedException('Not authorized to update this customer');
        }
        if (updateCustomerDto.email && updateCustomerDto.email !== customer.email) {
            const existingCustomer = await this.customersRepository.findOne({ where: { email: updateCustomerDto.email } });
            if (existingCustomer) {
                throw new common_2.ConflictException('Email already exists');
            }
        }
        if (updateCustomerDto.gen_customer_id && updateCustomerDto.gen_customer_id !== customer.genCustomerId) {
            const existingCustomer = await this.customersRepository.findOne({ where: { genCustomerId: updateCustomerDto.gen_customer_id } });
            if (existingCustomer) {
                throw new common_2.ConflictException('Generated customer ID already exists');
            }
        }
        if (updateCustomerDto.assigned_to_id) {
            const assignee = await this.usersRepository.findOne({ where: { id: parseInt(updateCustomerDto.assigned_to_id.toString(), 10) } });
            if (!assignee) {
                throw new common_2.NotFoundException(`User with ID ${updateCustomerDto.assigned_to_id} not found`);
            }
        }
        const updatedCustomer = this.customersRepository.merge(customer, {
            firstName: updateCustomerDto.first_name,
            lastName: updateCustomerDto.last_name,
            email: updateCustomerDto.email,
            mobileNumber: updateCustomerDto.mobile_phone,
            landline: updateCustomerDto.home_phone,
            title: updateCustomerDto.title,
            iso: updateCustomerDto.iso,
            dnc: updateCustomerDto.DNC,
            isLandLineDefault: updateCustomerDto.is_land_line_default,
            isActive: updateCustomerDto.is_active,
            customerId: updateCustomerDto.customer_id,
            genCustomerId: updateCustomerDto.gen_customer_id,
            assigned_to_id: updateCustomerDto.assigned_to_id ? parseInt(updateCustomerDto.assigned_to_id.toString(), 10) : customer.assigned_to_id,
        });
        if (updateCustomerDto.address) {
            const existingAddresses = customer.addresses || [];
            const updatedAddressIds = updateCustomerDto.address
                .filter((addr) => addr.id)
                .map((addr) => addr.id);
            for (const existingAddress of existingAddresses) {
                if (!updatedAddressIds.includes(existingAddress.id)) {
                    existingAddress.isActive = false;
                    await this.addressesRepository.save(existingAddress);
                }
            }
            const addresses = await Promise.all(updateCustomerDto.address.map(async (addr) => {
                if (addr.id) {
                    const existingAddress = existingAddresses.find((ea) => ea.id === addr.id);
                    if (existingAddress) {
                        return this.addressesRepository.merge(existingAddress, {
                            ...addr,
                            isActive: addr.is_active !== undefined ? addr.is_active : existingAddress.isActive,
                        });
                    }
                }
                return this.addressesRepository.create({
                    ...addr,
                    customer: updatedCustomer,
                    isActive: addr.is_active !== undefined ? addr.is_active : true,
                });
            }));
            updatedCustomer.addresses = addresses;
        }
        return this.customersRepository.save(updatedCustomer);
    }
    async findOne(id, user) {
        if (!user || !user.id) {
            throw new common_2.UnauthorizedException('User must be authenticated');
        }
        const roleName = typeof user.role === 'string'
            ? user.role
            : user.role?.name || '';
        const customer = await this.customersRepository.findOne({
            where: { id },
            relations: ['addresses', 'assignedTo', 'assignedTo.reportsTo'],
        });
        if (!customer) {
            throw new common_2.NotFoundException(`Customer with ID ${id} not found`);
        }
        const activeAddresses = customer.addresses?.filter(addr => addr.isActive !== false) || [];
        const notes = await this.customerNotesRepository.find({
            where: { customer: { id } },
            relations: ['parentNote'],
            order: { createdAt: 'DESC' },
        });
        const creator = await this.usersRepository.findOne({ where: { id: customer.createdById } });
        const transformedNotes = notes.map(note => ({
            id: note.id,
            replies: [],
            created_by: {
                id: user.id,
                user: {
                    email: user.email,
                    name: creator ? `${creator.firstName || ''} ${creator.lastName || ''}`.trim() || user.email : user.email,
                    last_login: user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: user.createdAt || new Date(),
                updated_at: user.updatedAt || new Date(),
                is_active: user.isActive,
            },
            total_parents_count: 0,
            created_at: note.createdAt,
            updated_at: note.updatedAt,
            is_active: true,
            note: note.note,
            customer: customer.id,
            parent_note: note.parentNote ? note.parentNote.id : null,
            child_note: null,
        }));
        return {
            id: customer.id,
            customer_notes: transformedNotes,
            address: activeAddresses,
            assigned_to: customer.assignedTo ? {
                id: customer.assignedTo.id,
                user: {
                    email: customer.assignedTo.email || '',
                    name: `${customer.assignedTo.firstName || ''} ${customer.assignedTo.lastName || ''}`.trim() || customer.assignedTo.email || '',
                    last_login: customer.assignedTo.lastLogin || null,
                },
                granted_permissions: customer.assignedTo.permissions || [],
                role: {
                    id: '',
                    name: customer.assignedTo.role || '',
                    permissions: [],
                },
                reports_to: customer.assignedTo.reportsTo ? customer.assignedTo.reportsTo.id : null,
                created_at: customer.assignedTo.createdAt || null,
                updated_at: customer.assignedTo.updatedAt || null,
                is_active: customer.assignedTo.isActive ?? true,
            } : null,
            created_by: {
                id: user.id,
                user: {
                    email: user.email,
                    name: creator ? `${creator.firstName || ''} ${creator.lastName || ''}`.trim() || user.email : user.email,
                    last_login: user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: user.createdAt || new Date(),
                updated_at: user.updatedAt || new Date(),
                is_active: user.isActive,
            },
            created_at: customer.createdAt,
            updated_at: customer.updatedAt,
            is_active: customer.isActive,
            customer_id: customer.customerId,
            gen_customer_id: customer.genCustomerId,
            title: customer.title,
            first_name: customer.firstName,
            last_name: customer.lastName,
            email: customer.email,
            mobile_phone: customer.dnc === true ? 'DNC' : customer.mobileNumber || '',
            home_phone: customer.dnc === true ? 'DNC' : customer.landline || '',
            is_land_line_default: customer.isLandLineDefault,
            iso: customer.iso,
            DNC: customer.dnc,
        };
    }
    async findOneByCustomerId(customerId, user) {
        if (!user || !user.id) {
            throw new common_2.UnauthorizedException('User must be authenticated');
        }
        const roleName = typeof user.role === 'string'
            ? user.role
            : user.role?.name || '';
        console.log(`Querying customer with customer_id: ${customerId} (type: ${typeof customerId}) for user ID: ${user.id}`);
        const customer = await this.customersRepository.findOne({
            where: { customerId: customerId.toString() },
            relations: ['addresses', 'assignedTo', 'assignedTo.reportsTo'],
        });
        if (!customer) {
            console.error(`No customer found with customer_id: ${customerId}`);
            throw new common_2.NotFoundException(`Customer with customer_id ${customerId} not found`);
        }
        const activeAddresses = customer.addresses?.filter(addr => addr.isActive !== false) || [];
        const notes = await this.customerNotesRepository.find({
            where: { customer: { id: customer.id } },
            relations: ['parentNote'],
            order: { createdAt: 'DESC' },
        });
        const creator = await this.usersRepository.findOne({ where: { id: customer.createdById } });
        const transformedNotes = notes.map(note => ({
            id: note.id,
            replies: [],
            created_by: {
                id: user.id,
                user: {
                    email: user.email,
                    name: creator ? `${creator.firstName || ''} ${creator.lastName || ''}`.trim() || user.email : user.email,
                    last_login: user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: user.createdAt || new Date(),
                updated_at: user.updatedAt || new Date(),
                is_active: user.isActive,
            },
            total_parents_count: 0,
            created_at: note.createdAt,
            updated_at: note.updatedAt,
            is_active: true,
            note: note.note,
            customer: customer.id,
            parent_note: note.parentNote ? note.parentNote.id : null,
            child_note: null,
        }));
        return {
            id: customer.id,
            customer_notes: transformedNotes,
            address: (customer.addresses || []).filter(addr => addr.isActive !== false),
            assigned_to: customer.assignedTo ? {
                id: customer.assignedTo.id,
                user: {
                    email: customer.assignedTo.email || '',
                    name: `${customer.assignedTo.firstName || ''} ${customer.assignedTo.lastName || ''}`.trim() || customer.assignedTo.email || '',
                    last_login: customer.assignedTo.lastLogin || null,
                },
                granted_permissions: customer.assignedTo.permissions || [],
                role: {
                    id: '',
                    name: customer.assignedTo.role || '',
                    permissions: [],
                },
                reports_to: customer.assignedTo.reportsTo ? customer.assignedTo.reportsTo.id : null,
                created_at: customer.assignedTo.createdAt || null,
                updated_at: customer.assignedTo.updatedAt || null,
                is_active: customer.assignedTo.isActive ?? true,
            } : null,
            created_by: {
                id: user.id,
                user: {
                    email: user.email,
                    name: creator ? `${creator.firstName || ''} ${creator.lastName || ''}`.trim() || user.email : user.email,
                    last_login: user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: user.createdAt || new Date(),
                updated_at: user.updatedAt || new Date(),
                is_active: user.isActive,
            },
            created_at: customer.createdAt,
            updated_at: customer.updatedAt,
            is_active: customer.isActive,
            customer_id: customer.customerId,
            gen_customer_id: customer.genCustomerId,
            title: customer.title,
            first_name: customer.firstName,
            last_name: customer.lastName,
            email: customer.email,
            mobile_phone: customer.dnc === true ? 'DNC' : customer.mobileNumber || '',
            home_phone: customer.dnc === true ? 'DNC' : customer.landline || '',
            is_land_line_default: customer.isLandLineDefault,
            iso: customer.iso,
            DNC: customer.dnc,
        };
    }
    async findAll(listCustomersDto, user) {
        if (!user || !user.id) {
            throw new common_2.UnauthorizedException('User must be authenticated');
        }
        const roleName = typeof user.role === 'string'
            ? user.role
            : user.role?.name || '';
        const { offset = 0, limit = 10, search, scope } = listCustomersDto;
        const qb = this.customersRepository.createQueryBuilder('customer')
            .leftJoinAndSelect('customer.addresses', 'addresses')
            .leftJoinAndSelect('customer.assignedTo', 'assignedTo')
            .leftJoinAndSelect('assignedTo.reportsTo', 'reportsTo')
            .skip(offset)
            .take(limit)
            .orderBy('customer.createdAt', 'DESC');
        const fieldMap = {
            first_name: 'customer.firstName',
            last_name: 'customer.lastName',
            email: 'customer.email',
            mobile_phone: 'customer.mobileNumber',
            home_phone: 'customer.landline',
            id: 'customer.id',
        };
        if (scope === 'created_by') {
            qb.andWhere('customer.createdById = :createdById', { createdById: user.id });
        }
        else if (scope && !fieldMap[scope]) {
            qb.andWhere('customer.iso = :iso', { iso: scope });
        }
        if (search) {
            if (scope && fieldMap[scope]) {
                qb.andWhere(`${fieldMap[scope]} LIKE :search`, { search: `%${search}%` });
            }
            else {
                qb.andWhere([
                    'customer.firstName LIKE :search',
                    'customer.lastName LIKE :search',
                    'customer.id LIKE :search',
                    'customer.email LIKE :search',
                    'customer.mobileNumber LIKE :search',
                    'customer.landline LIKE :search',
                ].join(' OR '), { search: `%${search}%` });
            }
        }
        const [data, total] = await qb.getManyAndCount();
        const creatorIds = [...new Set(data.map(customer => customer.createdById))];
        const creators = await this.usersRepository.find({ where: { id: (0, typeorm_2.In)(creatorIds) } });
        const creatorMap = new Map(creators.map(creator => [creator.id, creator]));
        const transformedData = data.map(customer => ({
            id: customer.id,
            customer_notes: [],
            first_name: customer.firstName,
            last_name: customer.lastName,
            email: customer.email,
            mobile_phone: customer.dnc === true ? 'DNC' : customer.mobileNumber || '',
            home_phone: customer.dnc === true ? 'DNC' : customer.landline || '',
            address: (customer.addresses || []).filter(addr => addr.isActive !== false),
            title: customer.title,
            iso: customer.iso,
            DNC: customer.dnc,
            is_land_line_default: customer.isLandLineDefault,
            created_at: customer.createdAt,
            updated_at: customer.updatedAt,
            is_active: customer.isActive ?? true,
            customer_id: customer.customerId,
            gen_customer_id: customer.genCustomerId,
            assigned_to: customer.assignedTo ? {
                id: customer.assignedTo.id,
                user: {
                    email: customer.assignedTo.email || '',
                    name: `${customer.assignedTo.firstName || ''} ${customer.assignedTo.lastName || ''}`.trim() || customer.assignedTo.email || '',
                    last_login: customer.assignedTo.lastLogin || null,
                },
                granted_permissions: customer.assignedTo.permissions || [],
                role: {
                    id: '',
                    name: customer.assignedTo.role || '',
                    permissions: [],
                },
                reports_to: customer.assignedTo.reportsTo ? customer.assignedTo.reportsTo.id : null,
                created_at: customer.assignedTo.createdAt || null,
                updated_at: customer.assignedTo.updatedAt || null,
                is_active: customer.assignedTo.isActive ?? true,
            } : null,
            created_by: {
                id: customer.createdById,
                user: {
                    email: creatorMap.get(customer.createdById)?.email || user.email,
                    name: creatorMap.get(customer.createdById) ?
                        `${creatorMap.get(customer.createdById)?.firstName || ''} ${creatorMap.get(customer.createdById)?.lastName || ''}`.trim() || user.email : user.email,
                    last_login: creatorMap.get(customer.createdById)?.lastLogin || user.lastLogin || new Date(),
                },
                granted_permissions: user.permissions || [],
                role: {
                    id: '',
                    name: roleName || '',
                    permissions: [],
                },
                reports_to: user.reportsTo ? user.reportsTo.id : null,
                created_at: creatorMap.get(customer.createdById)?.createdAt || user.createdAt || new Date(),
                updated_at: creatorMap.get(customer.createdById)?.updatedAt || user.updatedAt || new Date(),
                is_active: creatorMap.get(customer.createdById)?.isActive ?? user.isActive,
            },
        }));
        return { data: transformedData, total };
    }
    async bulkAssign(dto, user) {
        const { customer_ids, assigned_to_id } = dto;
        if (!user || !user.id) {
            throw new common_2.UnauthorizedException('User must be authenticated');
        }
        const assignee = await this.usersRepository.findOne({ where: { id: assigned_to_id } });
        if (!assignee) {
            throw new common_2.NotFoundException(`User with ID ${assigned_to_id} not found`);
        }
        const customers = await this.customersRepository.findBy({ id: (0, typeorm_2.In)(customer_ids) });
        if (!customers.length) {
            throw new common_2.NotFoundException(`No customers found with the provided IDs`);
        }
        for (const customer of customers) {
            customer.assigned_to_id = assigned_to_id;
        }
        await this.customersRepository.save(customers);
        return `Selected customers have been assigned to ${assignee.firstName || ''}_${assignee.lastName || 'user'}`;
    }
    async bulkCreate(file, user) {
        const results = { success: 0, failed: 0, errors: [], duplicateIds: [] };
        try {
            if (!file || !file.buffer) {
                throw new common_1.BadRequestException('File is required and must not be empty');
            }
            let workbook;
            try {
                workbook = XLSX.read(file.buffer, { type: 'buffer' });
            }
            catch (error) {
                throw new common_1.BadRequestException(`Failed to read Excel file: ${error.message}. Please ensure the file is a valid Excel format (.xlsx or .xls)`);
            }
            if (!workbook.SheetNames || workbook.SheetNames.length === 0) {
                throw new common_1.BadRequestException('Excel file has no sheets. Please ensure the file contains at least one worksheet.');
            }
            const worksheet = workbook.Sheets[workbook.SheetNames[0]];
            if (!worksheet) {
                throw new common_1.BadRequestException('Excel file worksheet is empty or corrupted. Please check the file and try again.');
            }
            let records;
            try {
                records = XLSX.utils.sheet_to_json(worksheet);
            }
            catch (error) {
                throw new common_1.BadRequestException(`Failed to parse Excel data: ${error.message}. Please check the file format.`);
            }
            if (!records || !Array.isArray(records)) {
                throw new common_1.BadRequestException('Excel file could not be parsed. Please ensure the file is a valid Excel format and contains data.');
            }
            if (records.length === 0) {
                throw new common_1.BadRequestException('The Excel file is empty. Please ensure the file contains at least one data row (in addition to the header row).');
            }
            if (!records[0] || typeof records[0] !== 'object') {
                throw new common_1.BadRequestException('Excel file format is invalid. Please ensure the first row contains headers and the second row contains data.');
            }
            const requiredColumns = ['first_name', 'last_name'];
            const missingColumns = requiredColumns.filter(col => !(col in records[0]));
            if (missingColumns.length > 0) {
                throw new common_1.BadRequestException(`Missing required columns: ${missingColumns.join(', ')}. Please ensure your Excel file has these columns in the first row.`);
            }
            const duplicateRowsInFile = this.findDuplicateRowsInFile(records);
            const existingCustomerIds = new Set();
            const existingMobileNumbers = new Set();
            const existingHomePhones = new Set();
            const existingEmails = new Set();
            const customerIds = [];
            const mobileNumbers = [];
            const homePhones = [];
            const emails = [];
            records.forEach((record) => {
                if (record.id) {
                    const id = record.id.toString().trim();
                    if (id)
                        customerIds.push(id);
                }
                if (record.mobile_phone) {
                    const mobile = record.mobile_phone.toString().trim();
                    if (mobile)
                        mobileNumbers.push(mobile);
                }
                if (record.home_phone) {
                    const homePhone = record.home_phone.toString().trim();
                    if (homePhone)
                        homePhones.push(homePhone);
                }
                if (record.email) {
                    const email = record.email.toString().trim().toLowerCase();
                    if (email)
                        emails.push(email);
                }
            });
            if (customerIds.length > 0) {
                const existingCustomersById = await this.customersRepository.find({
                    where: { genCustomerId: (0, typeorm_2.In)(customerIds) },
                    select: ['id', 'genCustomerId'],
                });
                existingCustomersById.forEach((customer) => {
                    if (customer.genCustomerId) {
                        existingCustomerIds.add(customer.genCustomerId);
                    }
                });
            }
            if (mobileNumbers.length > 0) {
                const existingCustomersByMobile = await this.customersRepository.find({
                    where: { mobileNumber: (0, typeorm_2.In)(mobileNumbers) },
                    select: ['id', 'mobileNumber'],
                });
                existingCustomersByMobile.forEach((customer) => {
                    if (customer.mobileNumber) {
                        existingMobileNumbers.add(customer.mobileNumber);
                    }
                });
            }
            if (homePhones.length > 0) {
                const existingCustomersByHomePhone = await this.customersRepository.find({
                    where: { landline: (0, typeorm_2.In)(homePhones) },
                    select: ['id', 'landline'],
                });
                existingCustomersByHomePhone.forEach((customer) => {
                    if (customer.landline) {
                        existingHomePhones.add(customer.landline);
                    }
                });
            }
            if (emails.length > 0) {
                const existingCustomersByEmail = await this.customersRepository.find({
                    where: { email: (0, typeorm_2.In)(emails) },
                    select: ['id', 'email'],
                });
                existingCustomersByEmail.forEach((customer) => {
                    if (customer.email) {
                        existingEmails.add(customer.email.toLowerCase());
                    }
                });
            }
            for (let index = 0; index < records.length; index++) {
                const record = records[index];
                const rowNumber = index + 2;
                try {
                    const duplicateReasonsInFile = duplicateRowsInFile.get(index);
                    if (duplicateReasonsInFile && duplicateReasonsInFile.length > 0) {
                        results.failed++;
                        const recordId = record.id?.toString().trim();
                        if (recordId) {
                            results.duplicateIds.push(recordId);
                        }
                        results.errors.push(`Row ${rowNumber}: Duplicate found within Excel file - ${duplicateReasonsInFile.join(', ')} already appears in a previous row`);
                        continue;
                    }
                    const recordId = record.id?.toString().trim();
                    const recordMobile = record.mobile_phone?.toString().trim();
                    const recordHomePhone = record.home_phone?.toString().trim();
                    const recordEmail = record.email?.toString().trim().toLowerCase();
                    let isDuplicate = false;
                    const duplicateReasons = [];
                    if (recordId && existingCustomerIds.has(recordId)) {
                        duplicateReasons.push(`Customer ID "${recordId}"`);
                        isDuplicate = true;
                    }
                    if (recordMobile && existingMobileNumbers.has(recordMobile)) {
                        duplicateReasons.push(`Mobile number "${recordMobile}"`);
                        isDuplicate = true;
                    }
                    if (recordHomePhone && existingHomePhones.has(recordHomePhone)) {
                        duplicateReasons.push(`Home phone "${recordHomePhone}"`);
                        isDuplicate = true;
                    }
                    if (recordEmail && existingEmails.has(recordEmail)) {
                        duplicateReasons.push(`Email "${recordEmail}"`);
                        isDuplicate = true;
                    }
                    if (isDuplicate) {
                        results.failed++;
                        if (recordId) {
                            results.duplicateIds.push(recordId);
                        }
                        results.errors.push(`Row ${rowNumber}: Duplicate found - ${duplicateReasons.join(', ')} already exists in database`);
                        continue;
                    }
                    if (!record.first_name || !record.last_name) {
                        throw new common_1.BadRequestException('First name and last name are required');
                    }
                    if (record.mobile_phone) {
                        const trimmedMobile = record.mobile_phone.toString().trim();
                        if (trimmedMobile.length === 0) {
                            throw new common_1.BadRequestException('Mobile phone cannot be empty if provided');
                        }
                    }
                    if (record.id) {
                        const trimmedId = record.id.toString().trim();
                        if (trimmedId.length === 0) {
                            throw new common_1.BadRequestException('Customer ID cannot be empty if provided');
                        }
                    }
                    const addressFields = {
                        address1: record.address1?.toString().trim() || undefined,
                        address2: record.address2?.toString().trim() || undefined,
                        town_city: record.town_city?.toString().trim() || undefined,
                        county: record.county?.toString().trim() || undefined,
                        country: record.country?.toString().trim() || undefined,
                        post_code: record.post_code?.toString().trim() || undefined,
                        formatted_address: record.formatted_address?.toString().trim() || undefined,
                        primary: record.primary !== undefined
                            ? (typeof record.primary === 'boolean'
                                ? record.primary
                                : record.primary.toString().toLowerCase() === 'true' || record.primary.toString() === '1')
                            : false,
                        hasAtLeastOneField: true,
                    };
                    const hasAddressData = (!!addressFields.address1 ||
                        !!addressFields.address2 ||
                        !!addressFields.town_city ||
                        !!addressFields.county ||
                        !!addressFields.country ||
                        !!addressFields.post_code ||
                        !!addressFields.formatted_address ||
                        addressFields.primary === true);
                    const addressArray = hasAddressData ? [addressFields] : undefined;
                    const createCustomerDto = {
                        first_name: record.first_name?.trim() || '',
                        last_name: record.last_name?.trim() || '',
                        email: record.email?.trim() || undefined,
                        mobile_phone: record.mobile_phone?.toString().trim() || undefined,
                        home_phone: record.home_phone?.toString().trim() || undefined,
                        title: record.title?.trim() || undefined,
                        iso: record.iso?.trim() || undefined,
                        assigned_to_id: record.assigned_to_id
                            ? parseInt(record.assigned_to_id.toString(), 10)
                            : undefined,
                        address: addressArray,
                    };
                    const customer = await this.create(createCustomerDto, user);
                    if (record.id) {
                        const customerId = record.id.toString().trim();
                        const existingWithId = await this.customersRepository.findOne({
                            where: { genCustomerId: customerId },
                        });
                        if (existingWithId && existingWithId.id !== customer.id) {
                            results.failed++;
                            results.duplicateIds.push(customerId);
                            results.errors.push(`Row ${rowNumber}: Customer ID "${customerId}" already exists`);
                            continue;
                        }
                        customer.genCustomerId = customerId;
                        await this.customersRepository.save(customer);
                    }
                    results.success++;
                }
                catch (error) {
                    results.failed++;
                    const errorMessage = error.message || 'Unknown error';
                    const recordId = record.id?.toString().trim();
                    if (recordId && !results.duplicateIds.includes(recordId)) {
                        if (errorMessage.includes('already exists') || errorMessage.includes('duplicate')) {
                            results.duplicateIds.push(recordId);
                        }
                    }
                    results.errors.push(`Row ${rowNumber}: ${errorMessage}`);
                }
            }
            let message = '';
            if (results.success > 0 && results.failed === 0) {
                message = `Successfully created ${results.success} customer${results.success > 1 ? 's' : ''}.`;
            }
            else if (results.success > 0 && results.failed > 0) {
                message = `Successfully created ${results.success} customer${results.success > 1 ? 's' : ''}. ${results.failed} record${results.failed > 1 ? 's' : ''} skipped due to duplicates.`;
            }
            else {
                message = `No customers were created. All records were duplicates or had errors.`;
            }
            return { message, details: results };
        }
        catch (error) {
            if (error instanceof common_1.BadRequestException || error instanceof common_2.ConflictException) {
                throw error;
            }
            throw new common_1.BadRequestException(error.message || 'Invalid Excel file');
        }
    }
    findDuplicateRowsInFile(records) {
        const duplicateRows = new Map();
        const seenIds = new Map();
        const seenMobileNumbers = new Map();
        const seenHomePhones = new Map();
        const seenEmails = new Map();
        records.forEach((record, index) => {
            const reasons = [];
            if (record.id) {
                const id = record.id.toString().trim().toLowerCase();
                if (id) {
                    if (seenIds.has(id)) {
                        reasons.push(`Customer ID "${id}"`);
                    }
                    else {
                        seenIds.set(id, index);
                    }
                }
            }
            if (record.mobile_phone) {
                const mobileNumber = record.mobile_phone.toString().trim();
                if (mobileNumber) {
                    if (seenMobileNumbers.has(mobileNumber)) {
                        reasons.push(`Mobile number "${mobileNumber}"`);
                    }
                    else {
                        seenMobileNumbers.set(mobileNumber, index);
                    }
                }
            }
            if (record.home_phone) {
                const homePhone = record.home_phone.toString().trim();
                if (homePhone) {
                    if (seenHomePhones.has(homePhone)) {
                        reasons.push(`Home phone "${homePhone}"`);
                    }
                    else {
                        seenHomePhones.set(homePhone, index);
                    }
                }
            }
            if (record.email) {
                const email = record.email.toString().trim().toLowerCase();
                if (email) {
                    if (seenEmails.has(email)) {
                        reasons.push(`Email "${email}"`);
                    }
                    else {
                        seenEmails.set(email, index);
                    }
                }
            }
            if (reasons.length > 0) {
                duplicateRows.set(index, reasons);
            }
        });
        return duplicateRows;
    }
    validateDuplicatesInFile(records) {
        const errors = [];
        const seenIds = new Map();
        const seenMobileNumbers = new Map();
        records.forEach((record, index) => {
            const rowNumber = index + 2;
            if (record.id) {
                const id = record.id.toString().trim().toLowerCase();
                if (id) {
                    if (seenIds.has(id)) {
                        const existingRows = seenIds.get(id) || [];
                        existingRows.push(rowNumber);
                        seenIds.set(id, existingRows);
                        errors.push(`Customer ID "${id}" appears in rows: ${existingRows.join(', ')}`);
                    }
                    else {
                        seenIds.set(id, [rowNumber]);
                    }
                }
            }
            if (record.mobile_phone) {
                const mobileNumber = record.mobile_phone.toString().trim();
                if (mobileNumber) {
                    if (seenMobileNumbers.has(mobileNumber)) {
                        const existingRows = seenMobileNumbers.get(mobileNumber) || [];
                        existingRows.push(rowNumber);
                        seenMobileNumbers.set(mobileNumber, existingRows);
                        errors.push(`Mobile number "${mobileNumber}" appears in rows: ${existingRows.join(', ')}`);
                    }
                    else {
                        seenMobileNumbers.set(mobileNumber, [rowNumber]);
                    }
                }
            }
        });
        return {
            hasDuplicates: errors.length > 0,
            errors,
        };
    }
    async checkExistingRecords(records) {
        const errors = [];
        const customerIds = [];
        const mobileNumbers = [];
        records.forEach((record, index) => {
            const rowNumber = index + 2;
            if (record.id) {
                const id = record.id.toString().trim();
                if (id) {
                    customerIds.push(id);
                }
            }
            if (record.mobile_phone) {
                const mobile = record.mobile_phone.toString().trim();
                if (mobile) {
                    mobileNumbers.push(mobile);
                }
            }
        });
        if (customerIds.length > 0) {
            const existingCustomersById = await this.customersRepository.find({
                where: { genCustomerId: (0, typeorm_2.In)(customerIds) },
                select: ['id', 'genCustomerId'],
            });
            if (existingCustomersById.length > 0) {
                existingCustomersById.forEach((customer) => {
                    errors.push(`Customer ID "${customer.genCustomerId}" already exists in database`);
                });
            }
        }
        if (mobileNumbers.length > 0) {
            const existingCustomersByMobile = await this.customersRepository.find({
                where: { mobileNumber: (0, typeorm_2.In)(mobileNumbers) },
                select: ['id', 'mobileNumber'],
            });
            if (existingCustomersByMobile.length > 0) {
                existingCustomersByMobile.forEach((customer) => {
                    errors.push(`Mobile number "${customer.mobileNumber}" already exists in database`);
                });
            }
        }
        return {
            hasExisting: errors.length > 0,
            errors,
        };
    }
};
exports.CustomersService = CustomersService;
exports.CustomersService = CustomersService = __decorate([
    (0, common_2.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(customer_entity_1.Customer)),
    __param(1, (0, typeorm_1.InjectRepository)(address_entity_1.Address)),
    __param(2, (0, typeorm_1.InjectRepository)(customer_note_entity_1.CustomerNote)),
    __param(3, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], CustomersService);
//# sourceMappingURL=customers.service.js.map