import {
  Entity,
  PrimaryGeneratedColumn,
  Column,
  CreateDateColumn,
  UpdateDateColumn,
  OneToMany,
  ManyToOne,
  JoinColumn,
} from 'typeorm';
import { UserActivity } from '../../user-activity/entities/user-activity.entity'; // ✅ adjust this path as needed

@Entity('users')
export class User {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ unique: true })
  email: string;

  @Column()
  firstName: string;

  @Column()
  lastName: string;

  @Column({ default: true })
  isActive: boolean;

  @Column({
    type: 'enum',
    enum: ['Team Lead', 'Retention', 'Reactivation', 'Owner', 'Escalator', 'Agent', 'Admin'],
    default: 'Agent',
  })
  role: string;

  @Column({ type: 'int', default: 1 })
  status: number;

  @Column({ default: false })
  emailVerified: boolean;

  @Column({ nullable: true })
  lastLoginAt: Date;

  @Column({ nullable: true })
  lastLogin: Date;

  @Column({ type: 'json', nullable: true })
  permissions: any[] = []; // Initialize as empty array

  @ManyToOne(() => User, { nullable: true })
  @JoinColumn({ name: 'reports_to_id' })
  reportsTo: User;

  @Column({ nullable: true })
  created_by: number;

  @OneToMany(() => User, user => user.reportsTo)
  reports: User[];

  @CreateDateColumn({ name: 'created_at' })
  createdAt: Date;

  @UpdateDateColumn({ name: 'updated_at' })
  updatedAt: Date;

  @OneToMany(() => UserActivity, (activity) => activity.user)
  activities: UserActivity[];
}