import { IsString, IsEmail, IsArray, IsNotEmpty, IsOptional } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

export class UserInfoDto {
  @ApiProperty({ example: 'test@gmail.com' })
  @IsEmail()
  @IsNotEmpty()
  email: string;

  @ApiProperty({ example: 'Test' })
  @IsString()
  @IsNotEmpty()
  name: string;
}

export class CreateUserDto {
  @ApiProperty({ type: [String], example: ['89', '90', '92', '97', '98', '100', '104', '105', '108'] })
  @IsArray()
  @IsString({ each: true })
  permissions: string[];

  @ApiProperty({ type: UserInfoDto })
  @IsNotEmpty()
  user: UserInfoDto;

  @ApiProperty({ example: '7' })
  @IsString()
  @IsNotEmpty()
  role_id: string;

  @ApiProperty({ example: '5', required: false })
  @IsString()
  @IsOptional()
  reports_to_id?: string;
} 