import { IsInt, Min, IsOptional, IsString } from 'class-validator';
import { Type } from 'class-transformer';

export class ListCustomersDto {
  @IsInt()
  @Min(0)
  @Type(() => Number)
  offset: number;

  @IsInt()
  @Min(1)
  @Type(() => Number)
  limit: number;

  @IsString()
  @IsOptional()
  search: string;

  @IsString()
  @IsOptional()
  scope: string;
}