import { TypeOrmModuleOptions } from '@nestjs/typeorm';
import { ConfigService } from '@nestjs/config';
import { DefaultNamingStrategy } from 'typeorm';

export const getDatabaseConfig = (configService: ConfigService): TypeOrmModuleOptions => ({
  type: 'mysql',
  host: configService.get('DB_HOST'),
  port: configService.get('DB_PORT'),
  username: configService.get('DB_USERNAME'),
  password: configService.get('DB_PASSWORD'),
  database: configService.get('DB_DATABASE'),
  entities: [__dirname + '/../**/*.entity{.ts,.js}'],
  synchronize: true, // Keep enabled - now compatible with MySQL 8.0.43
  logging: ['query', 'error'], // Enable query and error logging
  logger: 'advanced-console',
  namingStrategy: new DefaultNamingStrategy(),
  extra: {
    // MySQL 8.0.43 compatibility settings
    charset: 'utf8mb4',
    timezone: 'Z',
    // Set sql_mode to be compatible with TypeORM
    sql_mode: 'TRADITIONAL,NO_ZERO_DATE,NO_ZERO_IN_DATE,ERROR_FOR_DIVISION_BY_ZERO',
  },
});