import { Repository, DataSource } from 'typeorm';
import { User } from './entities/user.entity';
import { CreateUserDto } from './dto/create-user.dto';
import { UpdateUserDto } from './dto/update-user.dto';
import { EmailService } from '../common/services/email.service';
import { UserActivity } from '../user-activity/entities/user-activity.entity';
import { PermissionsService } from '../permissions/permissions.service';
import { Login } from '../login/entities/login.entity';
export declare class UsersService {
    private usersRepository;
    private activityRepository;
    private loginRepository;
    private emailService;
    private permissionsService;
    private dataSource;
    private readonly logger;
    constructor(usersRepository: Repository<User>, activityRepository: Repository<UserActivity>, loginRepository: Repository<Login>, emailService: EmailService, permissionsService: PermissionsService, dataSource: DataSource);
    private sanitizeUser;
    logActivity(data: Partial<UserActivity>): Promise<UserActivity>;
    private recordActivity;
    private getRoleName;
    private getRoleIdFromName;
    create(createUserDto: CreateUserDto, creatorId: number): Promise<any>;
    findAll(limit?: number, offset?: number, search?: string, isActive?: boolean, requestingUser?: User): Promise<{
        next: string | null;
        previous: string | null;
        count: number;
        limit: number;
        offset: number;
        status: number;
        success: boolean;
        message: string;
        data: Array<{
            id: number;
            user: {
                email: string;
                name: string;
                last_login: string | null;
            };
            role: {
                id: number;
                name: string;
                permissions: Array<{
                    id: number;
                    name: string;
                    codename: string;
                    content_type: number;
                }>;
            };
            reports_to: {
                id: number;
                user: {
                    email: string;
                    name: string;
                    last_login: string | null;
                };
                granted_permissions: Array<{
                    id: number;
                    name: string;
                    codename: string;
                    content_type: number;
                }>;
            } | null;
            granted_permissions: Array<{
                id: number;
                name: string;
                codename: string;
                content_type: number;
            }>;
            is_active: boolean;
        }>;
    }>;
    findOne(id: number, requestingUser?: User): Promise<any>;
    findByEmail(email: string): Promise<User | null>;
    update(id: number, updateUserDto: UpdateUserDto): Promise<any>;
    remove(id: number): Promise<{
        status: string;
        message: string;
    }>;
    deactivate(id: number): Promise<{
        user: Partial<User>;
        message: string;
    }>;
    reactivate(id: number): Promise<{
        user: Partial<User>;
        message: string;
    }>;
    findDeactivatedUsers(requestingUser?: User, ipAddress?: string): Promise<User[]>;
    bulkCreate(file: Express.Multer.File): Promise<{
        message: string;
        details: {
            success: number;
            failed: number;
            errors: string[];
        };
    }>;
}
