import { UsersService } from './users.service';
import { CreateUserDto } from './dto/create-user.dto';
import { UpdateUserDto } from './dto/update-user.dto';
import { User } from './entities/user.entity';
interface RequestWithUser extends Request {
    user: User;
    requestingUser?: User;
}
export declare class UsersController {
    private readonly usersService;
    private readonly logger;
    constructor(usersService: UsersService);
    create(createUserDto: CreateUserDto, req: RequestWithUser): Promise<any>;
    findAll(limit: string, offset: string, search: string, isActive: string, req: RequestWithUser): Promise<{
        next: string | null;
        previous: string | null;
        count: number;
        limit: number;
        offset: number;
        status: number;
        success: boolean;
        message: string;
        data: Array<{
            id: number;
            user: {
                email: string;
                name: string;
                last_login: string | null;
            };
            role: {
                id: number;
                name: string;
                permissions: Array<{
                    id: number;
                    name: string;
                    codename: string;
                    content_type: number;
                }>;
            };
            reports_to: {
                id: number;
                user: {
                    email: string;
                    name: string;
                    last_login: string | null;
                };
                granted_permissions: Array<{
                    id: number;
                    name: string;
                    codename: string;
                    content_type: number;
                }>;
            } | null;
            granted_permissions: Array<{
                id: number;
                name: string;
                codename: string;
                content_type: number;
            }>;
            is_active: boolean;
        }>;
    }>;
    findDeactivatedUsers(req: RequestWithUser): Promise<User[]>;
    findOne(id: string, req: RequestWithUser): Promise<any>;
    update(id: string, updateUserDto: UpdateUserDto, req: Request): Promise<any>;
    reactivate(id: string, req: Request): Promise<{
        user: Partial<User>;
        message: string;
    }>;
    deactivate(id: string, req: Request): Promise<{
        user: Partial<User>;
        message: string;
    }>;
    remove(id: string, req: Request): Promise<{
        status: string;
        message: string;
    }>;
    bulkCreate(file: Express.Multer.File, req: Request): Promise<{
        message: string;
        details: {
            success: number;
            failed: number;
            errors: string[];
        };
    }>;
    createAssign(createUserDto: CreateUserDto, req: RequestWithUser): Promise<any>;
    findAllAssign(limit: string, offset: string, search: string, isActive: string, req: RequestWithUser): Promise<{
        next: string | null;
        previous: string | null;
        count: number;
        limit: number;
        offset: number;
        status: number;
        success: boolean;
        message: string;
        data: Array<{
            id: number;
            user: {
                email: string;
                name: string;
                last_login: string | null;
            };
            role: {
                id: number;
                name: string;
                permissions: Array<{
                    id: number;
                    name: string;
                    codename: string;
                    content_type: number;
                }>;
            };
            reports_to: {
                id: number;
                user: {
                    email: string;
                    name: string;
                    last_login: string | null;
                };
                granted_permissions: Array<{
                    id: number;
                    name: string;
                    codename: string;
                    content_type: number;
                }>;
            } | null;
            granted_permissions: Array<{
                id: number;
                name: string;
                codename: string;
                content_type: number;
            }>;
            is_active: boolean;
        }>;
    }>;
    findDeactivatedAssign(req: RequestWithUser): Promise<User[]>;
    findOneAssign(id: string, req: RequestWithUser): Promise<any>;
    updateAssign(id: string, updateUserDto: UpdateUserDto, req: Request): Promise<any>;
    reactivateAssign(id: string, req: Request): Promise<{
        user: Partial<User>;
        message: string;
    }>;
    deactivateAssign(id: string, req: Request): Promise<{
        user: Partial<User>;
        message: string;
    }>;
    removeAssign(id: string, req: Request): Promise<{
        status: string;
        message: string;
    }>;
    bulkCreateAssign(file: Express.Multer.File, req: Request): Promise<{
        message: string;
        details: {
            success: number;
            failed: number;
            errors: string[];
        };
    }>;
}
export {};
