"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const permission_entity_1 = require("./entities/permission.entity");
let PermissionsService = class PermissionsService {
    permissionsRepository;
    constructor(permissionsRepository) {
        this.permissionsRepository = permissionsRepository;
    }
    getContentType(entity) {
        const contentTypeMap = {
            'log entry': 1,
            'permission': 2,
            'group': 3,
            'content type': 4,
            'session': 5,
            'blacklisted token': 6,
            'outstanding token': 7,
            'app version': 8,
            'audit log': 9,
            'otp': 10,
            'user activity': 11,
            'user notification': 12,
            'user': 13,
            'employees': 14,
            'historical employees': 15,
            'historical user': 16,
            'address': 23,
            'customer assignment history': 26,
            'customer notes': 27,
            'historical customer': 24,
            'customer': 25,
            'variation types': 28,
            'variation option': 29,
            'product': 30,
            'product variation': 31,
            'variation details': 32,
            'stock update log': 33,
            'order details': 34,
            'order item': 35,
            'historical proforma': 36,
            'proforma': 37
        };
        if (contentTypeMap[entity.toLowerCase()]) {
            return contentTypeMap[entity.toLowerCase()];
        }
        const altKey = `${entity.toLowerCase()}_alt`;
        if (contentTypeMap[altKey]) {
            return contentTypeMap[altKey];
        }
        return 0;
    }
    formatCodename(action, entity) {
        if (action.includes('Assigned To')) {
            return 'can_change_assigned_to';
        }
        else if (action.includes('DNC')) {
            return 'can_change_dnc';
        }
        else if (action.includes('Stock Level')) {
            return 'can_change_stock_level';
        }
        else if (action.includes('confirm order status')) {
            return 'can_confirm_order';
        }
        const actionMatch = action.match(/Can\s+(\w+)\s+(.+)/);
        if (!actionMatch)
            return action.toLowerCase().replace(/\s+/g, '_');
        const actionPart = actionMatch[1].toLowerCase();
        const entityPart = actionMatch[2].toLowerCase().replace(/\s+/g, '');
        return `${actionPart}_${entityPart}`;
    }
    async findAll(role) {
        let permissions;
        if (!role) {
            permissions = await this.permissionsRepository.find({
                order: {
                    category: 'ASC',
                    entity: 'ASC',
                    action: 'ASC',
                },
            });
        }
        else {
            let roleId;
            switch (role.toLowerCase()) {
                case '1':
                case 'admin':
                    roleId = '1';
                    break;
                case '2':
                case 'retention':
                    roleId = '2';
                    break;
                case '3':
                case 'reactivation':
                    roleId = '3';
                    break;
                case '4':
                case 'owner':
                    roleId = '4';
                    break;
                case '5':
                case 'escalator':
                    roleId = '5';
                    break;
                case '6':
                case 'agent':
                    roleId = '6';
                    break;
                case '7':
                case 'team lead':
                    roleId = '7';
                    break;
                default:
                    return {
                        data: [],
                        customer_permissions: [],
                        user_permissions: [],
                        success: true,
                        message: 'List Successfully Retrieved!',
                        status: 200
                    };
            }
            if (roleId === '1' || roleId === '4') {
                permissions = await this.permissionsRepository.find({
                    order: {
                        category: 'ASC',
                        entity: 'ASC',
                        action: 'ASC',
                    },
                });
            }
            else {
                permissions = await this.permissionsRepository
                    .createQueryBuilder('permission')
                    .where('permission.role LIKE :rolePattern', { rolePattern: `%${roleId}%` })
                    .orderBy('permission.category', 'ASC')
                    .addOrderBy('permission.entity', 'ASC')
                    .addOrderBy('permission.action', 'ASC')
                    .getMany();
            }
        }
        const formattedPermissions = permissions.map(permission => ({
            id: permission.id,
            name: permission.action,
            codename: this.formatCodename(permission.action, permission.entity),
            content_type: this.getContentType(permission.entity)
        }));
        const customerContentTypes = [11, 23, 15, 25, 16, 27];
        const userContentTypes = [8, 14];
        const customer_permissions = formattedPermissions.filter(p => customerContentTypes.includes(p.content_type));
        const user_permissions = formattedPermissions.filter(p => userContentTypes.includes(p.content_type));
        const groupedIds = new Set([
            ...customer_permissions.map(p => p.id),
            ...user_permissions.map(p => p.id)
        ]);
        const filteredData = formattedPermissions.filter(p => !groupedIds.has(p.id));
        const uniqueCustomerPermissions = Array.from(new Map(customer_permissions.map(p => [p.codename, p])).values());
        const uniqueUserPermissions = Array.from(new Map(user_permissions.map(p => [p.codename, p])).values());
        const customerPermissionOrder = [
            { entity: 'customer', action: 'Can add customer' },
            { entity: 'customer', action: 'Can change customer' },
            { entity: 'customer', action: 'Can view customer' },
            { entity: 'customer notes', action: 'Can add customer notes' },
            { entity: 'customer notes', action: 'Can view customer notes' },
            { entity: 'address', action: 'Can add address' },
            { entity: 'address', action: 'Can change address' },
            { entity: 'address', action: 'Can view address' },
        ];
        const ordered = customerPermissionOrder
            .map(order => uniqueCustomerPermissions.find(p => p.name === order.action && p.codename.includes(order.entity.replace(/\s/g, ''))))
            .filter((p) => Boolean(p));
        const orderedIds = new Set(ordered.map(p => p.id));
        const rest = uniqueCustomerPermissions.filter(p => !orderedIds.has(p.id));
        const sortedCustomerPermissions = [...ordered, ...rest];
        const allowedCustomerEntities = ['address', 'customer', 'customer notes'];
        const customerCategoryPermissions = permissions.filter(p => p.category === 'Customers' && allowedCustomerEntities.includes(p.entity.toLowerCase()));
        const formattedCustomerCategoryPermissions = customerCategoryPermissions.map(permission => ({
            id: permission.id,
            name: permission.action,
            codename: this.formatCodename(permission.action, permission.entity),
            content_type: this.getContentType(permission.entity)
        }));
        const uniqueCustomerCategoryPermissions = Array.from(new Map(formattedCustomerCategoryPermissions.map(p => [p.codename, p])).values());
        const orderedCustomerPermissions = customerPermissionOrder
            .map(order => uniqueCustomerCategoryPermissions.find(p => p.name === order.action && p.codename.includes(order.entity.replace(/\s/g, ''))))
            .filter((p) => Boolean(p));
        const orderedCustomerIds = new Set(orderedCustomerPermissions.map(p => p.id));
        const restCustomerPermissions = uniqueCustomerCategoryPermissions.filter(p => !orderedCustomerIds.has(p.id));
        const sortedCustomerPermissionsCustomer = [...orderedCustomerPermissions, ...restCustomerPermissions];
        return {
            data: [],
            customer_permissions: sortedCustomerPermissionsCustomer,
            user_permissions: uniqueUserPermissions,
            success: true,
            message: '',
            status: 200
        };
    }
    async findAllGrouped(role) {
        const flat = await this.findAll(role);
        return {
            ...flat,
            grouped: this.groupPermissions(flat.data)
        };
    }
    async findByCategory(category) {
        const permissions = await this.permissionsRepository.find({
            where: { category },
            order: {
                entity: 'ASC',
                action: 'ASC',
            },
        });
        const formattedPermissions = permissions.map(permission => ({
            id: permission.id,
            name: permission.action,
            codename: this.formatCodename(permission.action, permission.entity),
            content_type: this.getContentType(permission.entity)
        }));
        return {
            data: formattedPermissions,
            success: true,
            message: 'List Successfully Retrieved!',
            status: 200
        };
    }
    async findByEntity(category, entity) {
        const permissions = await this.permissionsRepository.find({
            where: { category, entity },
            order: {
                action: 'ASC',
            },
        });
        const formattedPermissions = permissions.map(permission => ({
            id: permission.id,
            name: permission.action,
            codename: this.formatCodename(permission.action, permission.entity),
            content_type: this.getContentType(permission.entity)
        }));
        return {
            data: formattedPermissions,
            success: true,
            message: 'List Successfully Retrieved!',
            status: 200
        };
    }
    async findOne(id) {
        return this.permissionsRepository.findOne({
            where: { id },
        });
    }
    async getAllPermissions() {
        const permissions = await this.permissionsRepository.find({
            order: {
                category: 'ASC',
                entity: 'ASC',
                action: 'ASC',
            },
        });
        return permissions.map(permission => ({
            id: permission.id,
            name: permission.action,
            codename: this.formatCodename(permission.action, permission.entity),
            content_type: this.getContentType(permission.entity)
        }));
    }
    groupPermissions(permissions) {
        const PERMISSION_GROUPS = {
            Customers: {
                address: [11, 23],
                customer: [15, 25],
                'customer notes': [16, 27],
            },
            Users: {
                employees: [8, 14],
            },
        };
        const grouped = {};
        for (const [module, submodules] of Object.entries(PERMISSION_GROUPS)) {
            grouped[module] = {};
            for (const [submodule, contentTypes] of Object.entries(submodules)) {
                grouped[module][submodule] = permissions.filter(p => contentTypes.includes(p.content_type));
            }
        }
        return grouped;
    }
};
exports.PermissionsService = PermissionsService;
exports.PermissionsService = PermissionsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(permission_entity_1.Permission)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], PermissionsService);
//# sourceMappingURL=permissions.service.js.map