"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogoutService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const user_entity_1 = require("../users/entities/user.entity");
const user_activity_service_1 = require("../user-activity/user-activity.service");
let LogoutService = class LogoutService {
    userRepo;
    userActivityService;
    constructor(userRepo, userActivityService) {
        this.userRepo = userRepo;
        this.userActivityService = userActivityService;
    }
    async logout(req, res) {
        const sessionUser = req.session?.user;
        const jwtUser = req.user;
        const sessionId = req.sessionID;
        if (!sessionUser && !jwtUser) {
            console.warn('No user found in session or JWT during logout');
            res.clearCookie('connect.sid');
            return res.status(200).json({ message: 'Logout successful ' });
        }
        const userEmail = sessionUser?.email || jwtUser?.email;
        if (!userEmail) {
            console.warn('No valid user email found during logout');
            res.clearCookie('connect.sid');
            return res.status(200).json({ message: 'Logout successful (no valid user)' });
        }
        const user = await this.userRepo.findOne({ where: { email: userEmail } });
        if (!user) {
            console.warn('User not found in DB during logout:', userEmail);
            res.clearCookie('connect.sid');
            return res.status(200).json({ message: 'Logout successful (user not found)' });
        }
        await this.userActivityService.logActivity({
            user,
            action: 'Logged Out',
            type: 'logout',
            ipAddress: req.ip || req.connection.remoteAddress || 'unknown',
            changedObject: `User ${user.email} logged out`,
            method: 'POST',
        });
        console.log('Logout activity logged. Destroying session:', sessionId);
        if (req.session) {
            req.session.destroy((err) => {
                if (err) {
                    console.error('Failed to destroy session:', err);
                    return res.status(500).json({ message: 'Logout failed' });
                }
                res.clearCookie('connect.sid');
                return res.status(200).json({ message: 'Logout successful' });
            });
        }
        else {
            res.clearCookie('connect.sid');
            return res.status(200).json({ message: 'Logout successful' });
        }
    }
};
exports.LogoutService = LogoutService;
exports.LogoutService = LogoutService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        user_activity_service_1.UserActivityService])
], LogoutService);
//# sourceMappingURL=logout.service.js.map