import { Repository } from 'typeorm';
import { Login } from './entities/login.entity';
import { User } from '../users/entities/user.entity';
import { EmailService } from '../common/services/email.service';
import { JwtService } from '@nestjs/jwt';
import { Request } from 'express';
import { UserActivityService } from '../user-activity/user-activity.service';
import { PermissionsService } from '../permissions/permissions.service';
export declare class LoginService {
    private readonly loginRepository;
    private readonly userRepository;
    private readonly emailService;
    private readonly jwtService;
    private readonly userActivityService;
    private readonly permissionsService;
    constructor(loginRepository: Repository<Login>, userRepository: Repository<User>, emailService: EmailService, jwtService: JwtService, userActivityService: UserActivityService, permissionsService: PermissionsService);
    private getClientIp;
    requestOTP(email: string, request: Request): Promise<{
        message: string;
    }>;
    verifyOTP(email: string, otp: string, request: Request): Promise<{
        user: any;
        accessToken: string;
        refreshToken: string;
    }>;
    private getRoleIdFromName;
    generateAccessToken(payload: any): string;
    generateRefreshToken(payload: any): string;
}
