"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerNotesController = void 0;
const common_1 = require("@nestjs/common");
const customer_notes_service_1 = require("./customer-notes.service");
const create_customer_note_dto_1 = require("./dto/create-customer-note.dto");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const permissions_guard_1 = require("../auth/guards/permissions.guard");
const require_permission_decorator_1 = require("../auth/decorators/require-permission.decorator");
const user_decorator_1 = require("../auth/decorators/user.decorator");
let CustomerNotesController = class CustomerNotesController {
    customerNotesService;
    constructor(customerNotesService) {
        this.customerNotesService = customerNotesService;
    }
    async create(createCustomerNoteDto, user) {
        console.log('POST request received at', new Date().toISOString(), 'with payload:', JSON.stringify(createCustomerNoteDto, null, 2));
        try {
            const note = await this.customerNotesService.create(createCustomerNoteDto, user);
            return {
                statusCode: common_1.HttpStatus.CREATED,
                message: 'Customer note created successfully',
                data: {
                    id: note.id,
                    note: note.note,
                    customer_id: note.customer.id,
                    parent_note_id: note.parentNote ? note.parentNote.id : null,
                    created_by_id: note.createdBy ? note.createdBy.id : null,
                    created_at: note.createdAt,
                    updated_at: note.updatedAt,
                },
            };
        }
        catch (error) {
            console.error('POST error:', error.message, error.stack);
            throw error;
        }
    }
    async findAll(customerId, ordering = '-created_at', limit, offset, user) {
        console.log('GET request received at', new Date().toISOString(), 'with params:', { customerId, ordering, limit, offset });
        try {
            const { data, count, next, previous } = await this.customerNotesService.findAll(customerId, ordering, limit, offset, user);
            return {
                next,
                previous,
                count,
                limit,
                offset,
                status: common_1.HttpStatus.OK,
                success: true,
                message: 'List Successfully Retrieved!',
                data,
            };
        }
        catch (error) {
            console.error('GET error:', error.message, error.stack);
            throw error;
        }
    }
};
exports.CustomerNotesController = CustomerNotesController;
__decorate([
    (0, common_1.Post)(),
    (0, require_permission_decorator_1.RequirePermission)('Can add customer notes'),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_customer_note_dto_1.CreateCustomerNoteDto, Object]),
    __metadata("design:returntype", Promise)
], CustomerNotesController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, require_permission_decorator_1.RequirePermission)('Can view customer notes'),
    __param(0, (0, common_1.Query)('customer', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Query)('ordering')),
    __param(2, (0, common_1.Query)('limit', new common_1.DefaultValuePipe(10), common_1.ParseIntPipe)),
    __param(3, (0, common_1.Query)('offset', new common_1.DefaultValuePipe(0), common_1.ParseIntPipe)),
    __param(4, (0, user_decorator_1.User)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String, Number, Number, Object]),
    __metadata("design:returntype", Promise)
], CustomerNotesController.prototype, "findAll", null);
exports.CustomerNotesController = CustomerNotesController = __decorate([
    (0, common_1.Controller)([
        'api/customer/notes',
        'api/customer/notes/',
        'api/customers/notes',
        'api/customers/notes/',
        'api/notes',
        'api/notes/',
    ]),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, permissions_guard_1.PermissionsGuard),
    __metadata("design:paramtypes", [customer_notes_service_1.CustomerNotesService])
], CustomerNotesController);
//# sourceMappingURL=customer-notes.controller.js.map