import { HttpStatus } from '@nestjs/common';
import { CustomerNotesService } from './customer-notes.service';
import { CreateCustomerNoteDto } from './dto/create-customer-note.dto';
export declare class CustomerNotesController {
    private readonly customerNotesService;
    constructor(customerNotesService: CustomerNotesService);
    create(createCustomerNoteDto: CreateCustomerNoteDto, user: any): Promise<{
        statusCode: HttpStatus;
        message: string;
        data: {
            id: number;
            note: string;
            customer_id: number;
            parent_note_id: number | null;
            created_by_id: number | null;
            created_at: Date;
            updated_at: Date;
        };
    }>;
    findAll(customerId: number, ordering: string | undefined, limit: number, offset: number, user: any): Promise<{
        next: string | null;
        previous: string | null;
        count: number;
        limit: number;
        offset: number;
        status: HttpStatus;
        success: boolean;
        message: string;
        data: any[];
    }>;
}
